/*
 * Decompiled with CFR 0.152.
 */
package com.poiji.bind.mapping;

import com.poiji.bind.PoijiInputStream;
import com.poiji.bind.mapping.XSSFUnmarshaller;
import com.poiji.exception.PoijiException;
import com.poiji.option.PoijiOptions;
import java.io.IOException;
import java.util.function.Consumer;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.xml.sax.SAXException;

final class XSSFUnmarshallerStream
extends XSSFUnmarshaller {
    private final PoijiInputStream<?> poijiInputStream;

    XSSFUnmarshallerStream(PoijiInputStream<?> poijiInputStream, PoijiOptions options) {
        super(options);
        this.poijiInputStream = poijiInputStream;
    }

    @Override
    public <T> void unmarshal(Class<T> type, Consumer<? super T> consumer) {
        if (this.options.getPassword() != null) {
            this.returnFromEncryptedFile(type, consumer);
            return;
        }
        this.returnFromExcelFile(type, consumer);
    }

    @Override
    public <T> void returnFromExcelFile(Class<T> type, Consumer<? super T> consumer) {
        try (OPCPackage open = OPCPackage.open(this.poijiInputStream.stream());){
            this.unmarshal0(type, consumer, open);
        }
        catch (IOException | ParserConfigurationException | OpenXML4JException | SAXException e) {
            throw new PoijiException("Problem occurred while reading data", e);
        }
    }

    @Override
    public <T> void returnFromEncryptedFile(Class<T> type, Consumer<? super T> consumer) {
        try (POIFSFileSystem fs = new POIFSFileSystem(this.poijiInputStream.stream());){
            this.listOfEncryptedItems(type, consumer, fs);
        }
        catch (IOException e) {
            throw new PoijiException("Problem occurred while reading data", e);
        }
    }
}

