/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.exception;

import org.supercsv.exception.SuperCsvException;
import org.supercsv.util.CsvContext;

public class SuperCsvNoMatchHeaderException
extends SuperCsvException {
    private static final long serialVersionUID = 1L;
    protected final String[] actualHeaders;
    protected final String[] expectedHeaders;

    public SuperCsvNoMatchHeaderException(String[] actualHeaders, String[] expectedHeaders, CsvContext context) {
        super(String.format("'%s' is not equals to '%s'", SuperCsvNoMatchHeaderException.joinArray(actualHeaders, ","), SuperCsvNoMatchHeaderException.joinArray(expectedHeaders, ",")), context);
        this.actualHeaders = actualHeaders;
        this.expectedHeaders = expectedHeaders;
    }

    public String[] getActualHeaders() {
        return this.actualHeaders;
    }

    public String[] getExpectedHeaders() {
        return this.expectedHeaders;
    }

    public String getActualHeadersWithJoin(String seperator) {
        return SuperCsvNoMatchHeaderException.joinArray(this.actualHeaders, seperator);
    }

    public String getExpectedHeadersWithJoin(String seperator) {
        return SuperCsvNoMatchHeaderException.joinArray(this.expectedHeaders, seperator);
    }

    private static String joinArray(String[] arrays, String seperator) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < arrays.length) {
            sb.append(arrays[i]);
            if (i < arrays.length - 1) {
                sb.append(seperator);
            }
            ++i;
        }
        return sb.toString();
    }
}

