/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.cellprocessor.constraint;

import java.util.HashMap;
import java.util.Map;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.exception.SuperCsvConstraintViolationException;
import org.supercsv.ext.cellprocessor.ift.ValidationCellProcessor;
import org.supercsv.util.CsvContext;

public class Length
extends CellProcessorAdaptor
implements StringCellProcessor,
ValidationCellProcessor {
    protected final int min;
    protected final int max;

    public Length(int min, int max) {
        Length.checkPreconditions(min, max);
        this.min = min;
        this.max = max;
    }

    public Length(int min, int max, CellProcessor next) {
        super(next);
        Length.checkPreconditions(min, max);
        this.min = min;
        this.max = max;
    }

    private static void checkPreconditions(int min, int max) {
        if (max < min) {
            throw new IllegalArgumentException(String.format("max (%d) should not be < min (%d)", max, min));
        }
        if (min < 0) {
            throw new IllegalArgumentException(String.format("min length (%d) should not be < 0", min));
        }
    }

    public Object execute(Object value, CsvContext context) {
        this.validateInputNotNull(value, context);
        String stringValue = value.toString();
        int length = stringValue.length();
        if (length < this.min || length > this.max) {
            throw new SuperCsvConstraintViolationException(String.format("the length (%d) of value '%s' does not lie between the min (%d) and max (%d) values (inclusive)", length, stringValue, this.min, this.max), context, (CellProcessor)this);
        }
        return this.next.execute((Object)stringValue, context);
    }

    @Override
    public String getMessageCode() {
        return String.valueOf(Length.class.getCanonicalName()) + ".violated";
    }

    @Override
    public Map<String, ?> getMessageVariable() {
        HashMap<String, Integer> vars = new HashMap<String, Integer>();
        vars.put("min", this.getMin());
        vars.put("max", this.getMax());
        return vars;
    }

    @Override
    public String formatValue(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }
}

