/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.cellprocessor;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Currency;
import java.util.HashMap;
import java.util.Map;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.ext.cellprocessor.ift.ValidationCellProcessor;
import org.supercsv.util.CsvContext;

public class ParseLocaleNumber<N extends Number>
extends CellProcessorAdaptor
implements StringCellProcessor,
ValidationCellProcessor {
    protected final Class<N> type;
    protected final String pattern;
    protected final boolean lenient;
    protected final Currency currency;
    protected final DecimalFormatSymbols symbols;
    protected final ThreadLocal<NumberFormat> formatter = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            DecimalFormat value = null;
            value = ParseLocaleNumber.this.symbols != null ? new DecimalFormat(ParseLocaleNumber.this.pattern, ParseLocaleNumber.this.symbols) : new DecimalFormat(ParseLocaleNumber.this.pattern);
            value.setParseBigDecimal(true);
            if (ParseLocaleNumber.this.currency != null) {
                value.setCurrency(ParseLocaleNumber.this.currency);
            }
            return value;
        }
    };

    public ParseLocaleNumber(Class<N> type, String pattern) {
        this(type, pattern, true, null, null);
    }

    public ParseLocaleNumber(Class<N> type, String pattern, CellProcessor next) {
        this(type, pattern, true, null, null, next);
    }

    public ParseLocaleNumber(Class<N> type, String pattern, boolean lenient, Currency currency, DecimalFormatSymbols symbols) {
        ParseLocaleNumber.checkPreconditions(pattern);
        this.type = type;
        this.pattern = pattern;
        this.lenient = lenient;
        this.currency = currency;
        this.symbols = symbols;
    }

    public ParseLocaleNumber(Class<N> type, String pattern, boolean lenient, Currency currency, DecimalFormatSymbols symbols, CellProcessor next) {
        super(next);
        ParseLocaleNumber.checkPreconditions(pattern);
        this.type = type;
        this.pattern = pattern;
        this.lenient = lenient;
        this.currency = currency;
        this.symbols = symbols;
    }

    protected static void checkPreconditions(String pattern) {
        if (pattern == null || pattern.isEmpty()) {
            throw new IllegalArgumentException("pattern should not be null");
        }
    }

    public Object execute(Object value, CsvContext context) {
        this.validateInputNotNull(value, context);
        if (!(value instanceof String)) {
            throw new SuperCsvCellProcessorException(String.class, value, context, (CellProcessor)this);
        }
        try {
            Object result = this.parse((String)value);
            return this.next.execute(result, context);
        }
        catch (ParseException e) {
            throw new SuperCsvCellProcessorException(String.format("'%s' could not be parsed as a BigDecimal", value), context, (CellProcessor)this, (Throwable)e);
        }
    }

    protected Object parse(String value) throws ParseException {
        BigDecimal result = (BigDecimal)this.formatter.get().parse(value);
        if (Byte.class.isAssignableFrom(this.type) || Byte.TYPE.isAssignableFrom(this.type)) {
            return this.lenient ? result.byteValue() : result.byteValueExact();
        }
        if (Short.class.isAssignableFrom(this.type) || Short.TYPE.isAssignableFrom(this.type)) {
            return this.lenient ? result.shortValue() : result.shortValueExact();
        }
        if (Integer.class.isAssignableFrom(this.type) || Integer.TYPE.isAssignableFrom(this.type)) {
            return this.lenient ? result.intValue() : result.intValueExact();
        }
        if (Long.class.isAssignableFrom(this.type) || Long.TYPE.isAssignableFrom(this.type)) {
            return this.lenient ? result.longValue() : result.longValueExact();
        }
        if (Float.class.isAssignableFrom(this.type) || Float.TYPE.isAssignableFrom(this.type)) {
            return Float.valueOf(result.floatValue());
        }
        if (Double.class.isAssignableFrom(this.type) || Double.TYPE.isAssignableFrom(this.type)) {
            return result.doubleValue();
        }
        if (this.type.isAssignableFrom(BigInteger.class)) {
            return this.lenient ? result.toBigInteger() : result.toBigIntegerExact();
        }
        if (this.type.isAssignableFrom(BigDecimal.class)) {
            return result;
        }
        return result;
    }

    public Class<N> getType() {
        return this.type;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public DecimalFormatSymbols getSymbols() {
        return this.symbols;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public ThreadLocal<NumberFormat> getFormatter() {
        return this.formatter;
    }

    @Override
    public String getMessageCode() {
        return String.valueOf(ParseLocaleNumber.class.getCanonicalName()) + ".violated";
    }

    @Override
    public Map<String, ?> getMessageVariable() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("pattern", this.getPattern());
        vars.put("currency", this.getCurrency());
        vars.put("symbols", this.getSymbols().getCurrencySymbol());
        vars.put("lenient", this.isLenient());
        return vars;
    }

    @Override
    public String formatValue(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }
}

