/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.cellprocessor;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.DateCellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.ext.cellprocessor.ift.ValidationCellProcessor;
import org.supercsv.util.CsvContext;

public class ParseLocaleDate
extends CellProcessorAdaptor
implements StringCellProcessor,
ValidationCellProcessor {
    protected final String pattern;
    protected final boolean lenient;
    protected final Locale locale;
    protected final TimeZone timeZone;
    protected final ThreadLocal<DateFormat> formatter = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat value = new SimpleDateFormat(ParseLocaleDate.this.pattern, ParseLocaleDate.this.locale);
            value.setLenient(ParseLocaleDate.this.lenient);
            if (ParseLocaleDate.this.timeZone != null) {
                value.setTimeZone(ParseLocaleDate.this.timeZone);
            }
            return value;
        }
    };

    public ParseLocaleDate(String pattern) {
        this(pattern, true, Locale.getDefault(), null);
    }

    public ParseLocaleDate(String pattern, DateCellProcessor next) {
        this(pattern, true, Locale.getDefault(), null, next);
    }

    public ParseLocaleDate(String pattern, boolean lenient) {
        this(pattern, lenient, Locale.getDefault(), null);
    }

    public ParseLocaleDate(String pattern, boolean lenient, DateCellProcessor next) {
        this(pattern, lenient, Locale.getDefault(), null, next);
    }

    public ParseLocaleDate(String pattern, boolean lenient, Locale locale, TimeZone timeZone) {
        ParseLocaleDate.checkPreconditions(pattern);
        this.pattern = pattern;
        this.lenient = lenient;
        this.locale = locale == null ? Locale.getDefault() : locale;
        this.timeZone = timeZone;
    }

    public ParseLocaleDate(String pattern, boolean lenient, Locale locale, TimeZone timeZone, DateCellProcessor next) {
        super((CellProcessor)next);
        ParseLocaleDate.checkPreconditions(pattern);
        this.pattern = pattern;
        this.lenient = lenient;
        this.locale = locale == null ? Locale.getDefault() : locale;
        this.timeZone = timeZone;
    }

    protected static void checkPreconditions(String pattern) {
        if (pattern == null || pattern.isEmpty()) {
            throw new IllegalArgumentException("pattern should not be null or empty.");
        }
    }

    public Object execute(Object value, CsvContext context) {
        this.validateInputNotNull(value, context);
        if (!(value instanceof String)) {
            throw new SuperCsvCellProcessorException(String.class, value, context, (CellProcessor)this);
        }
        try {
            Object result = this.parse((String)value);
            return this.next.execute(result, context);
        }
        catch (ParseException e) {
            throw new SuperCsvCellProcessorException(String.format("'%s' could not be parsed as a Date", value), context, (CellProcessor)this, (Throwable)e);
        }
    }

    protected Object parse(String value) throws ParseException {
        Date result = this.formatter.get().parse(value);
        return result;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public ThreadLocal<DateFormat> getFormatter() {
        return this.formatter;
    }

    @Override
    public String getMessageCode() {
        return String.valueOf(this.getClass().getCanonicalName()) + ".violated";
    }

    @Override
    public Map<String, ?> getMessageVariable() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("pattern", this.getPattern());
        vars.put("locale", this.getLocale());
        vars.put("timeZone", this.getTimeZone());
        vars.put("lenient", this.isLenient());
        return vars;
    }

    @Override
    public String formatValue(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }
}

