/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.cellprocessor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.ext.Utils;
import org.supercsv.ext.cellprocessor.ift.ValidationCellProcessor;
import org.supercsv.util.CsvContext;

public class ParseEnum
extends CellProcessorAdaptor
implements StringCellProcessor,
ValidationCellProcessor {
    protected final Class type;
    protected final boolean lenient;
    protected final Map<String, Enum> enumValueMap;
    protected final Method valueMethod;

    public ParseEnum(Class type) {
        this(type, false);
    }

    public ParseEnum(Class type, CellProcessor next) {
        this(type, false, next);
    }

    public ParseEnum(Class type, String valueMethodName) {
        this(type, false, valueMethodName);
    }

    public ParseEnum(Class type, String valueMethodName, CellProcessor next) {
        this(type, false, valueMethodName, next);
    }

    public ParseEnum(Class type, boolean lenient) {
        ParseEnum.checkPreconditions(type);
        this.type = type;
        this.lenient = lenient;
        this.enumValueMap = this.createEnumMap(type, lenient);
        this.valueMethod = null;
    }

    public ParseEnum(Class type, boolean lenient, CellProcessor next) {
        super(next);
        ParseEnum.checkPreconditions(type);
        this.type = type;
        this.lenient = lenient;
        this.enumValueMap = this.createEnumMap(type, lenient);
        this.valueMethod = null;
    }

    public ParseEnum(Class type, boolean lenient, String valueMethodName) {
        ParseEnum.checkPreconditions(type);
        this.type = type;
        this.lenient = lenient;
        this.enumValueMap = this.createEnumMap(type, lenient, valueMethodName);
        this.valueMethod = this.createEnumValueMethod(type, valueMethodName);
    }

    public ParseEnum(Class type, boolean lenient, String valueMethodName, CellProcessor next) {
        super(next);
        ParseEnum.checkPreconditions(type);
        this.type = type;
        this.lenient = lenient;
        this.enumValueMap = this.createEnumMap(type, lenient, valueMethodName);
        this.valueMethod = this.createEnumValueMethod(type, valueMethodName);
    }

    protected static void checkPreconditions(Class type) {
        if (type == null) {
            throw new NullPointerException("type should be not null");
        }
        if (!Enum.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException(String.format("type should be Enum class : %s", type.getCanonicalName()));
        }
    }

    protected Method createEnumValueMethod(Class enumClass, String valueMethodName) {
        try {
            return enumClass.getMethod(valueMethodName, new Class[0]);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("not found method '%s'", valueMethodName), e);
        }
    }

    protected Map<String, Enum> createEnumMap(Class enumClass, boolean lenient) {
        LinkedHashMap<String, Enum> map = new LinkedHashMap<String, Enum>();
        EnumSet<Enum> set = EnumSet.allOf(enumClass);
        for (Enum e : set) {
            String key = lenient ? e.name().toLowerCase() : e.name();
            map.put(key, e);
        }
        return Collections.unmodifiableMap(map);
    }

    protected Map<String, Enum> createEnumMap(Class enumClass, boolean lenient, String methodName) {
        LinkedHashMap<String, Enum> map = new LinkedHashMap<String, Enum>();
        try {
            Method method = this.createEnumValueMethod(enumClass, methodName);
            EnumSet<Enum> set = EnumSet.allOf(enumClass);
            for (Enum e : set) {
                Object returnValue = method.invoke((Object)e, new Object[0]);
                String key = lenient ? returnValue.toString().toLowerCase() : returnValue.toString();
                map.put(key, e);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return Collections.unmodifiableMap(map);
    }

    public Object execute(Object value, CsvContext context) {
        Enum result;
        this.validateInputNotNull(value, context);
        if (value instanceof String) {
            String stringValue = this.lenient ? ((String)value).toLowerCase() : (String)value;
            result = this.enumValueMap.get(stringValue);
            if (result == null) {
                throw new SuperCsvCellProcessorException(String.format("'%s' could not be parsed as an Enum", value), context, (CellProcessor)this);
            }
        } else if (value instanceof Enum && value.getClass().isAssignableFrom(this.type)) {
            result = (Enum)value;
        } else {
            String actualClassName = value.getClass().getName();
            throw new SuperCsvCellProcessorException(String.format("the input value should be of type Enum or String but is of type %s", actualClassName), context, (CellProcessor)this);
        }
        return this.next.execute((Object)result, context);
    }

    public Class<?> getType() {
        return this.type;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public Map<String, Enum> getEnumValueMap() {
        return this.enumValueMap;
    }

    public Method getValueMethod() {
        return this.valueMethod;
    }

    @Override
    public String getMessageCode() {
        return String.valueOf(ParseEnum.class.getCanonicalName()) + ".violated";
    }

    @Override
    public Map<String, ?> getMessageVariable() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("type", this.getType().getCanonicalName());
        vars.put("valueMethod", this.getValueMethod() == null ? "" : this.getValueMethod().getName());
        ArrayList<String> enumValues = new ArrayList<String>();
        for (Map.Entry<String, Enum> entry : this.getEnumValueMap().entrySet()) {
            enumValues.add(entry.getValue().name());
        }
        vars.put("enumValues", enumValues);
        vars.put("enumsStr", Utils.join(enumValues, ", "));
        return vars;
    }

    @Override
    public String formatValue(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }
}

