/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.cellprocessor;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Currency;
import java.util.HashMap;
import java.util.Map;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.DoubleCellProcessor;
import org.supercsv.cellprocessor.ift.LongCellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.ext.cellprocessor.ift.ValidationCellProcessor;
import org.supercsv.util.CsvContext;

public class FormatLocaleNumber
extends CellProcessorAdaptor
implements DoubleCellProcessor,
LongCellProcessor,
ValidationCellProcessor {
    protected final String pattern;
    protected final Currency currency;
    protected final DecimalFormatSymbols symbols;
    protected final ThreadLocal<NumberFormat> formatter;

    public FormatLocaleNumber(String pattern) {
        this(pattern, null, null);
    }

    public FormatLocaleNumber(String pattern, StringCellProcessor next) {
        this(pattern, null, null, next);
    }

    public FormatLocaleNumber(final NumberFormat formatter) {
        this.pattern = null;
        this.currency = null;
        this.symbols = null;
        this.formatter = new ThreadLocal<NumberFormat>(){

            @Override
            protected NumberFormat initialValue() {
                return formatter;
            }
        };
    }

    public FormatLocaleNumber(final NumberFormat formatter, StringCellProcessor next) {
        super((CellProcessor)next);
        this.pattern = null;
        this.currency = null;
        this.symbols = null;
        this.formatter = new ThreadLocal<NumberFormat>(){

            @Override
            protected NumberFormat initialValue() {
                return formatter;
            }
        };
    }

    public FormatLocaleNumber(String pattern, Currency currency, DecimalFormatSymbols symbols) {
        FormatLocaleNumber.checkPreconditions(pattern);
        this.pattern = pattern;
        this.currency = currency;
        this.symbols = symbols;
        this.formatter = FormatLocaleNumber.createNumberFormatter(pattern, currency, symbols);
    }

    public FormatLocaleNumber(String pattern, Currency currency, DecimalFormatSymbols symbols, StringCellProcessor next) {
        super((CellProcessor)next);
        FormatLocaleNumber.checkPreconditions(pattern);
        this.pattern = pattern;
        this.currency = currency;
        this.symbols = symbols;
        this.formatter = FormatLocaleNumber.createNumberFormatter(pattern, currency, symbols);
    }

    public static ThreadLocal<NumberFormat> createNumberFormatter(final String pattern, final Currency currency, final DecimalFormatSymbols symbols) {
        return new ThreadLocal<NumberFormat>(){

            @Override
            protected NumberFormat initialValue() {
                DecimalFormat value = null;
                value = symbols != null ? new DecimalFormat(pattern, symbols) : new DecimalFormat(pattern);
                value.setParseBigDecimal(true);
                if (currency != null) {
                    value.setCurrency(currency);
                }
                return value;
            }
        };
    }

    protected static void checkPreconditions(String pattern) {
        if (pattern == null || pattern.isEmpty()) {
            throw new IllegalArgumentException("pattern should not be null");
        }
    }

    public Object execute(Object value, CsvContext context) {
        this.validateInputNotNull(value, context);
        if (!(value instanceof Number)) {
            throw new SuperCsvCellProcessorException(Number.class, value, context, (CellProcessor)this);
        }
        String result = this.formatter.get().format((Number)value);
        return this.next.execute((Object)result, context);
    }

    public String getPattern() {
        return this.pattern;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public DecimalFormatSymbols getSymbols() {
        return this.symbols;
    }

    public ThreadLocal<NumberFormat> getFormatter() {
        return this.formatter;
    }

    @Override
    public String getMessageCode() {
        return String.valueOf(FormatLocaleNumber.class.getCanonicalName()) + ".violated";
    }

    @Override
    public Map<String, ?> getMessageVariable() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("pattern", this.getPattern());
        vars.put("currency", this.getCurrency());
        vars.put("symbols", this.getSymbols());
        return vars;
    }

    @Override
    public String formatValue(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }
}

