/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.cellprocessor;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.DateCellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.ext.cellprocessor.ift.ValidationCellProcessor;
import org.supercsv.util.CsvContext;

public class FormatLocaleDate
extends CellProcessorAdaptor
implements DateCellProcessor,
ValidationCellProcessor {
    protected final String pattern;
    protected final Locale locale;
    protected final TimeZone timeZone;
    protected final ThreadLocal<DateFormat> formatter;

    public FormatLocaleDate(String pattern) {
        this(pattern, Locale.getDefault(), null);
    }

    public FormatLocaleDate(String pattern, DateCellProcessor next) {
        this(pattern, Locale.getDefault(), null, next);
    }

    public FormatLocaleDate(final DateFormat formatter) {
        this.pattern = null;
        this.locale = null;
        this.timeZone = null;
        this.formatter = new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return formatter;
            }
        };
    }

    public FormatLocaleDate(final DateFormat formatter, DateCellProcessor next) {
        this.pattern = null;
        this.locale = null;
        this.timeZone = null;
        this.formatter = new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return formatter;
            }
        };
    }

    public FormatLocaleDate(String pattern, Locale locale, TimeZone timeZone) {
        FormatLocaleDate.checkPreconditions(pattern, locale);
        this.pattern = pattern;
        this.locale = locale;
        this.timeZone = timeZone;
        this.formatter = FormatLocaleDate.createDateFormatter(pattern, locale, timeZone);
    }

    public FormatLocaleDate(String pattern, Locale locale, TimeZone timeZone, DateCellProcessor next) {
        super((CellProcessor)next);
        FormatLocaleDate.checkPreconditions(pattern, locale);
        this.pattern = pattern;
        this.locale = locale;
        this.timeZone = timeZone;
        this.formatter = FormatLocaleDate.createDateFormatter(pattern, locale, timeZone);
    }

    protected static ThreadLocal<DateFormat> createDateFormatter(final String pattern, final Locale locale, final TimeZone timeZone) {
        return new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                SimpleDateFormat value = new SimpleDateFormat(pattern, locale);
                if (timeZone != null) {
                    value.setTimeZone(timeZone);
                }
                return value;
            }
        };
    }

    protected static void checkPreconditions(String pattern, Locale locale) {
        if (pattern == null || pattern.isEmpty()) {
            throw new IllegalArgumentException("pattern should not be null");
        }
        if (locale == null) {
            throw new IllegalArgumentException("locale should not be null");
        }
    }

    public Object execute(Object value, CsvContext context) {
        this.validateInputNotNull(value, context);
        if (!(value instanceof Date)) {
            throw new SuperCsvCellProcessorException(Date.class, value, context, (CellProcessor)this);
        }
        String result = this.formatter.get().format((Date)value);
        return this.next.execute((Object)result, context);
    }

    public String getPattern() {
        return this.pattern;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public ThreadLocal<DateFormat> getFormatter() {
        return this.formatter;
    }

    @Override
    public String getMessageCode() {
        return String.valueOf(FormatLocaleDate.class.getCanonicalName()) + ".violated";
    }

    @Override
    public Map<String, ?> getMessageVariable() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("pattern", this.getPattern());
        vars.put("locale", this.getLocale());
        vars.put("timeZone", this.getTimeZone());
        return vars;
    }

    @Override
    public String formatValue(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }
}

