/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.builder;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.EnumSet;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.ext.annotation.CsvEnumConverter;
import org.supercsv.ext.builder.AbstractCellProcessorBuilder;
import org.supercsv.ext.cellprocessor.FormatEnum;
import org.supercsv.ext.cellprocessor.ParseEnum;
import org.supercsv.ext.exception.SuperCsvInvalidAnnotationException;

public class EnumCellProcessorBuilder
extends AbstractCellProcessorBuilder<Enum<?>> {
    protected CsvEnumConverter getAnnotation(Annotation[] annos) {
        if (annos == null || annos.length == 0) {
            return null;
        }
        Annotation[] annotationArray = annos;
        int n = annos.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation anno = annotationArray[n2];
            if (anno instanceof CsvEnumConverter) {
                return (CsvEnumConverter)anno;
            }
            ++n2;
        }
        return null;
    }

    protected boolean getLenient(CsvEnumConverter converterAnno) {
        if (converterAnno == null) {
            return false;
        }
        return converterAnno.lenient();
    }

    protected String getValueMethodName(CsvEnumConverter converterAnno) {
        if (converterAnno == null) {
            return "";
        }
        return converterAnno.valueMethodName();
    }

    @Override
    public CellProcessor buildOutputCellProcessor(Class<Enum<?>> type, Annotation[] annos, CellProcessor processor, boolean ignoreValidationProcessor) {
        CsvEnumConverter converterAnno = this.getAnnotation(annos);
        String valueMethodName = this.getValueMethodName(converterAnno);
        Object cellProcessor = processor;
        if (!valueMethodName.isEmpty()) {
            cellProcessor = cellProcessor == null ? new FormatEnum(type, valueMethodName) : new FormatEnum(type, valueMethodName, (StringCellProcessor)cellProcessor);
        }
        return cellProcessor;
    }

    @Override
    public CellProcessor buildInputCellProcessor(Class<Enum<?>> type, Annotation[] annos, CellProcessor processor) {
        CsvEnumConverter converterAnno = this.getAnnotation(annos);
        boolean lenient = this.getLenient(converterAnno);
        String valueMethodName = this.getValueMethodName(converterAnno);
        Object cellProcessor = processor;
        cellProcessor = valueMethodName.isEmpty() ? (cellProcessor == null ? new ParseEnum(type, lenient) : new ParseEnum((Class)type, lenient, (CellProcessor)cellProcessor)) : (cellProcessor == null ? new ParseEnum(type, lenient, valueMethodName) : new ParseEnum(type, lenient, valueMethodName, (CellProcessor)cellProcessor));
        return cellProcessor;
    }

    @Override
    public Enum getParseValue(Class<Enum<?>> type, Annotation[] annos, String defaultValue) {
        CsvEnumConverter converterAnno = this.getAnnotation(annos);
        boolean lenient = this.getLenient(converterAnno);
        String valueMethodName = this.getValueMethodName(converterAnno);
        EnumSet<Enum<?>> set = EnumSet.allOf(type);
        if (valueMethodName.isEmpty()) {
            for (Enum enum_ : set) {
                if (defaultValue.equals(enum_.name())) {
                    return enum_;
                }
                if (!lenient || !defaultValue.equalsIgnoreCase(enum_.name())) continue;
                return enum_;
            }
        } else {
            try {
                Method valueMethod = type.getMethod(valueMethodName, new Class[0]);
                for (Enum enum_ : set) {
                    String value = valueMethod.invoke((Object)enum_, new Object[0]).toString();
                    if (defaultValue.equals(value)) {
                        return enum_;
                    }
                    if (!lenient || !defaultValue.equalsIgnoreCase(value)) continue;
                    return enum_;
                }
            }
            catch (Exception e) {
                throw new SuperCsvInvalidAnnotationException(String.format("enum class '%s' has not method '%s'", type.getCanonicalName(), valueMethodName));
            }
        }
        throw new SuperCsvInvalidAnnotationException(String.format("convert fail enum value %s", defaultValue));
    }
}

