/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.ext.builder;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.supercsv.ext.builder.BooleanCellProcessorBuilder;
import org.supercsv.ext.builder.CellProcessorBuilder;
import org.supercsv.ext.builder.CharacterCellProcessorBuilder;
import org.supercsv.ext.builder.DateCellProcessorBuilder;
import org.supercsv.ext.builder.EnumCellProcessorBuilder;
import org.supercsv.ext.builder.NumberCellProcessorBuilder;
import org.supercsv.ext.builder.StringCellProcessorBuilder;

public class CellProcessorBuilderContainer {
    private final Map<Class<?>, CellProcessorBuilder> builderMap = new ConcurrentHashMap();

    public CellProcessorBuilderContainer() {
        this.init();
    }

    public void init() {
        this.builderMap.clear();
        this.registerBuilder(String.class, new StringCellProcessorBuilder());
        this.registerBuilder(Character.class, new CharacterCellProcessorBuilder());
        this.registerBuilder(Character.TYPE, new CharacterCellProcessorBuilder());
        this.registerBuilder(Boolean.class, new BooleanCellProcessorBuilder());
        this.registerBuilder(Boolean.TYPE, new BooleanCellProcessorBuilder());
        this.registerBuilder(Byte.class, NumberCellProcessorBuilder.newByte());
        this.registerBuilder(Byte.TYPE, NumberCellProcessorBuilder.newByte());
        this.registerBuilder(Short.class, NumberCellProcessorBuilder.newShort());
        this.registerBuilder(Short.TYPE, NumberCellProcessorBuilder.newShort());
        this.registerBuilder(Integer.class, NumberCellProcessorBuilder.newInteger());
        this.registerBuilder(Integer.TYPE, NumberCellProcessorBuilder.newInteger());
        this.registerBuilder(Long.class, NumberCellProcessorBuilder.newLong());
        this.registerBuilder(Long.TYPE, NumberCellProcessorBuilder.newLong());
        this.registerBuilder(Float.class, NumberCellProcessorBuilder.newFloat());
        this.registerBuilder(Float.TYPE, NumberCellProcessorBuilder.newFloat());
        this.registerBuilder(Double.class, NumberCellProcessorBuilder.newDouble());
        this.registerBuilder(Double.TYPE, NumberCellProcessorBuilder.newDouble());
        this.registerBuilder(BigDecimal.class, NumberCellProcessorBuilder.newBigDecimal());
        this.registerBuilder(BigInteger.class, NumberCellProcessorBuilder.newBigInteger());
        this.registerBuilder(java.util.Date.class, new DateCellProcessorBuilder());
        this.registerBuilder(Date.class, DateCellProcessorBuilder.newSqlDate());
        this.registerBuilder(Timestamp.class, DateCellProcessorBuilder.newTimestamp());
        this.registerBuilder(Time.class, DateCellProcessorBuilder.newTime());
        this.registerBuilder(Enum.class, new EnumCellProcessorBuilder());
    }

    public <T> void registerBuilder(Class<?> type, CellProcessorBuilder<T> builder) {
        this.builderMap.put(type, builder);
    }

    public <T> CellProcessorBuilder<T> getBuilder(Class<?> type) {
        return this.builderMap.get(type);
    }
}

