/*
 * Decompiled with CFR 0.152.
 */
package br.com.fluentvalidator.rule;

import br.com.fluentvalidator.Validator;
import br.com.fluentvalidator.annotation.CleanValidationContextException;
import br.com.fluentvalidator.aspect.ValidationExceptionAdvice;
import br.com.fluentvalidator.builder.AttemptedValue;
import br.com.fluentvalidator.builder.Code;
import br.com.fluentvalidator.builder.Critical;
import br.com.fluentvalidator.builder.FieldName;
import br.com.fluentvalidator.builder.HandleInvalidField;
import br.com.fluentvalidator.builder.Message;
import br.com.fluentvalidator.builder.Must;
import br.com.fluentvalidator.builder.RuleBuilderProperty;
import br.com.fluentvalidator.builder.WhenProperty;
import br.com.fluentvalidator.builder.WheneverProperty;
import br.com.fluentvalidator.builder.WithValidator;
import br.com.fluentvalidator.context.ValidationContext;
import br.com.fluentvalidator.exception.ValidationException;
import br.com.fluentvalidator.handler.HandlerInvalidField;
import br.com.fluentvalidator.rule.AbstractRuleBuilder;
import br.com.fluentvalidator.rule.AbstractValidationRule;
import br.com.fluentvalidator.rule.Rule;
import br.com.fluentvalidator.rule.RuleProcessorStrategy;
import br.com.fluentvalidator.rule.ValidationRule;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

public class RuleBuilderPropertyImpl<T, P>
extends AbstractRuleBuilder<T, P, WhenProperty<T, P>, WheneverProperty<T, P>>
implements RuleBuilderProperty<T, P>,
WhenProperty<T, P>,
WheneverProperty<T, P> {
    private final Collection<Rule<P>> rules = new LinkedList<Rule<P>>();
    private final RuleProcessorStrategy ruleProcessor = RuleProcessorStrategy.getFailFast();
    private ValidationRule<P, P> currentValidation;

    public RuleBuilderPropertyImpl(String fieldName, Function<T, P> function) {
        super(fieldName, function);
    }

    public RuleBuilderPropertyImpl(Function<T, P> function) {
        super(function);
    }

    @Override
    public boolean apply(T instance) {
        Object value = Objects.nonNull(instance) ? (Object)this.function.apply(instance) : null;
        return this.ruleProcessor.process(instance, value, this.rules);
    }

    @Override
    public WheneverProperty<T, P> whenever(Predicate<P> whenever) {
        this.currentValidation = new ValidatorRuleInternal(this.fieldName, whenever);
        this.rules.add(this.currentValidation);
        return this;
    }

    @Override
    public Must<T, P, WhenProperty<T, P>, WheneverProperty<T, P>> must(Predicate<P> must) {
        this.currentValidation = new ValidationRuleInternal(this.fieldName, must);
        this.rules.add(this.currentValidation);
        return this;
    }

    @Override
    public Message<T, P, WhenProperty<T, P>, WheneverProperty<T, P>> withMessage(String message) {
        this.currentValidation.withMessage((? obj) -> message);
        return this;
    }

    @Override
    public Message<T, P, WhenProperty<T, P>, WheneverProperty<T, P>> withMessage(Function<T, String> message) {
        this.currentValidation.withMessage(message);
        return this;
    }

    @Override
    public Code<T, P, WhenProperty<T, P>, WheneverProperty<T, P>> withCode(String code) {
        this.currentValidation.withCode((? obj) -> code);
        return this;
    }

    @Override
    public Code<T, P, WhenProperty<T, P>, WheneverProperty<T, P>> withCode(Function<T, String> code) {
        this.currentValidation.withCode(code);
        return this;
    }

    @Override
    public FieldName<T, P, WhenProperty<T, P>, WheneverProperty<T, P>> withFieldName(String fieldName) {
        this.currentValidation.withFieldName((? obj) -> fieldName);
        return this;
    }

    @Override
    public FieldName<T, P, WhenProperty<T, P>, WheneverProperty<T, P>> withFieldName(Function<T, String> fieldName) {
        this.currentValidation.withFieldName(fieldName);
        return this;
    }

    @Override
    public AttemptedValue<T, P, WhenProperty<T, P>, WheneverProperty<T, P>> withAttempedValue(Object attemptedValue) {
        this.currentValidation.withAttemptedValue(obj -> attemptedValue);
        return this;
    }

    @Override
    public AttemptedValue<T, P, WhenProperty<T, P>, WheneverProperty<T, P>> withAttempedValue(Function<T, Object> attemptedValue) {
        this.currentValidation.withAttemptedValue(attemptedValue);
        return this;
    }

    @Override
    public Critical<T, P, WhenProperty<T, P>, WheneverProperty<T, P>> critical() {
        this.currentValidation.critical();
        return this;
    }

    @Override
    public Critical<T, P, WhenProperty<T, P>, WheneverProperty<T, P>> critical(Class<? extends ValidationException> clazz) {
        this.currentValidation.critical(clazz);
        return this;
    }

    @Override
    public HandleInvalidField<T, P, WhenProperty<T, P>, WheneverProperty<T, P>> handlerInvalidField(HandlerInvalidField<P> handlerInvalidField) {
        this.currentValidation.withHandlerInvalidField(handlerInvalidField);
        return this;
    }

    @Override
    public WithValidator<T, P, WhenProperty<T, P>, WheneverProperty<T, P>> withValidator(Validator<P> validator) {
        this.currentValidation.withValidator(validator);
        return this;
    }

    public WhenProperty<T, P> when(Predicate<P> predicate) {
        this.currentValidation.when(predicate);
        return this;
    }

    class ValidationRuleInternal
    extends AbstractValidationRule<P, P> {
        private static /* synthetic */ Annotation ajc$anno$0;

        ValidationRuleInternal(Function<T, String> fieldName, Predicate<P> must) {
            super.must(must);
            super.withFieldName(fieldName);
        }

        @Override
        public boolean support(P instance) {
            return Boolean.TRUE.equals(this.getWhen().test(instance));
        }

        @Override
        @CleanValidationContextException
        public boolean apply(Object obj, P instance) {
            try {
                boolean apply = this.getMust().test(instance);
                if (Boolean.FALSE.equals(apply)) {
                    ValidationContext.get().addErrors(this.getHandlerInvalid().handle(obj, instance));
                }
                if (Objects.nonNull(this.getCriticalException()) && Boolean.FALSE.equals(apply)) {
                    throw ValidationException.create(this.getCriticalException());
                }
                return !Boolean.TRUE.equals(this.isCritical()) || !Boolean.FALSE.equals(apply);
            }
            catch (Throwable throwable) {
                ValidationExceptionAdvice validationExceptionAdvice = ValidationExceptionAdvice.aspectOf();
                Annotation annotation = ajc$anno$0;
                if (annotation == null) {
                    annotation = ajc$anno$0 = ValidationRuleInternal.class.getDeclaredMethod("apply", Object.class, Object.class).getAnnotation(CleanValidationContextException.class);
                }
                validationExceptionAdvice.afterThrowing((CleanValidationContextException)annotation);
                throw throwable;
            }
        }
    }

    class ValidatorRuleInternal
    extends AbstractValidationRule<P, P> {
        private static /* synthetic */ Annotation ajc$anno$0;

        ValidatorRuleInternal(Function<T, String> fieldName, Predicate<P> whenever) {
            super.whenever(whenever);
            super.withFieldName(fieldName);
        }

        @Override
        public boolean support(P instance) {
            return Boolean.TRUE.equals(this.getWhenever().test(instance));
        }

        @Override
        @CleanValidationContextException
        public boolean apply(Object obj, P instance) {
            try {
                boolean apply = RuleBuilderPropertyImpl.this.ruleProcessor.process(obj, instance, this.getValidator());
                if (Objects.nonNull(this.getCriticalException()) && Boolean.FALSE.equals(apply)) {
                    throw ValidationException.create(this.getCriticalException());
                }
                return !Boolean.TRUE.equals(this.isCritical()) || !Boolean.FALSE.equals(apply);
            }
            catch (Throwable throwable) {
                ValidationExceptionAdvice validationExceptionAdvice = ValidationExceptionAdvice.aspectOf();
                Annotation annotation = ajc$anno$0;
                if (annotation == null) {
                    annotation = ajc$anno$0 = ValidatorRuleInternal.class.getDeclaredMethod("apply", Object.class, Object.class).getAnnotation(CleanValidationContextException.class);
                }
                validationExceptionAdvice.afterThrowing((CleanValidationContextException)annotation);
                throw throwable;
            }
        }
    }
}

