/*
 * Decompiled with CFR 0.152.
 */
package br.com.fluentvalidator.rule;

import br.com.fluentvalidator.AbstractValidator;
import br.com.fluentvalidator.Validator;
import br.com.fluentvalidator.context.Error;
import br.com.fluentvalidator.exception.ValidationException;
import br.com.fluentvalidator.handler.HandlerInvalidField;
import br.com.fluentvalidator.rule.FieldDescriptor;
import br.com.fluentvalidator.rule.ValidationRule;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

abstract class AbstractValidationRule<T, P>
implements ValidationRule<T, P>,
FieldDescriptor<Object, P> {
    private Predicate<P> whenever = w -> true;
    private Predicate<P> when = w -> true;
    private Predicate<P> must = m -> true;
    private Function<Object, String> message = obj -> null;
    private Function<Object, String> code = obj -> null;
    private Function<Object, String> fieldName = obj -> null;
    private Function<Object, Object> attemptedValue;
    private boolean critical;
    private Class<? extends ValidationException> criticalException;
    private Validator<T> validator = new InternalValidator();
    private HandlerInvalidField<P> handlerInvalidField = new InternalHandlerInvalidField(this);

    AbstractValidationRule() {
    }

    public Predicate<P> getWhenever() {
        return this.whenever;
    }

    public Predicate<P> getWhen() {
        return this.when;
    }

    public Predicate<P> getMust() {
        return this.must;
    }

    public Class<? extends ValidationException> getCriticalException() {
        return this.criticalException;
    }

    public Validator<T> getValidator() {
        return this.validator;
    }

    @Override
    public String getMessage(Object instance) {
        return this.message.apply(instance);
    }

    @Override
    public String getCode(Object instance) {
        return this.code.apply(instance);
    }

    @Override
    public String getFieldName(Object instance) {
        return this.fieldName.apply(instance);
    }

    @Override
    public Object getAttemptedValue(Object instance, P defaultValue) {
        return Objects.isNull(this.attemptedValue) ? defaultValue : this.attemptedValue.apply(instance);
    }

    public HandlerInvalidField<P> getHandlerInvalid() {
        return this.handlerInvalidField;
    }

    public boolean isCritical() {
        return this.critical;
    }

    @Override
    public void when(Predicate<P> when) {
        this.when = when;
    }

    @Override
    public void must(Predicate<P> must) {
        this.must = must;
    }

    @Override
    public void withFieldName(Function<?, String> fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public void withMessage(Function<?, String> message) {
        this.message = message;
    }

    @Override
    public void withCode(Function<?, String> code) {
        this.code = code;
    }

    @Override
    public void withAttemptedValue(Function<?, Object> attemptedValue) {
        this.attemptedValue = attemptedValue;
    }

    @Override
    public void withHandlerInvalidField(HandlerInvalidField<P> handlerInvalidField) {
        this.handlerInvalidField = handlerInvalidField;
    }

    @Override
    public void critical() {
        this.critical = true;
    }

    @Override
    public void critical(Class<? extends ValidationException> clazz) {
        this.critical = true;
        this.criticalException = clazz;
    }

    @Override
    public void whenever(Predicate<P> whenever) {
        this.whenever = whenever;
    }

    @Override
    public void withValidator(Validator<T> validator) {
        this.validator = validator;
    }

    private class InternalHandlerInvalidField
    implements HandlerInvalidField<P> {
        private final FieldDescriptor<Object, P> fieldDescriptor;

        public InternalHandlerInvalidField(FieldDescriptor<Object, P> fieldDescriptor) {
            this.fieldDescriptor = fieldDescriptor;
        }

        @Override
        public Collection<Error> handle(Object instance, P attemptedValue) {
            return Collections.singletonList(Error.create(this.fieldDescriptor.getFieldName(instance), this.fieldDescriptor.getMessage(instance), this.fieldDescriptor.getCode(instance), this.fieldDescriptor.getAttemptedValue(instance, attemptedValue)));
        }
    }

    private class InternalValidator
    extends AbstractValidator<T> {
        private InternalValidator() {
        }

        @Override
        public void rules() {
        }
    }
}

