/*
 * Decompiled with CFR 0.152.
 */
package br.com.fluentvalidator;

import br.com.fluentvalidator.Validator;
import br.com.fluentvalidator.builder.RuleBuilderCollection;
import br.com.fluentvalidator.builder.RuleBuilderProperty;
import br.com.fluentvalidator.context.ProcessorContext;
import br.com.fluentvalidator.context.ValidationContext;
import br.com.fluentvalidator.context.ValidationResult;
import br.com.fluentvalidator.rule.Rule;
import br.com.fluentvalidator.rule.RuleBuilderCollectionImpl;
import br.com.fluentvalidator.rule.RuleBuilderPropertyImpl;
import br.com.fluentvalidator.rule.RuleProcessorStrategy;
import br.com.fluentvalidator.transform.ValidationResultTransform;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class AbstractValidator<T>
implements Validator<T> {
    private final List<Rule<T>> rules = new LinkedList<Rule<T>>();
    private final Initializer<T> initialize;
    private String property;
    private RuleProcessorStrategy ruleProcessor = RuleProcessorStrategy.getDefault();

    protected AbstractValidator() {
        this.initialize = new Initializer(this);
    }

    @Override
    public void failFastRule() {
        this.ruleProcessor = RuleProcessorStrategy.getFailFast();
    }

    @Override
    public Integer getCounter() {
        return ProcessorContext.get().get();
    }

    @Override
    public void setPropertyOnContext(String property) {
        this.property = property;
    }

    @Override
    public <P> P getPropertyOnContext(String property, Class<P> clazz) {
        return ValidationContext.get().getProperty(property, clazz);
    }

    @Override
    public ValidationResult validate(T instance) {
        this.ruleProcessor.process(instance, this);
        return ValidationContext.get().getValidationResult();
    }

    @Override
    public <E> E validate(T instance, ValidationResultTransform<E> resultTransform) {
        return resultTransform.transform(this.validate(instance));
    }

    @Override
    public List<ValidationResult> validate(Collection<T> instances) {
        return Collections.unmodifiableList(instances.stream().map(this::validate).collect(Collectors.toList()));
    }

    @Override
    public <E> List<E> validate(Collection<T> instances, ValidationResultTransform<E> resultTransform) {
        return Collections.unmodifiableList(instances.stream().map(instance -> this.validate(instance, resultTransform)).collect(Collectors.toList()));
    }

    @Override
    public boolean apply(T instance) {
        this.initialize.init();
        ValidationContext.get().setProperty(this.property, instance);
        return this.ruleProcessor.process(instance, instance, this.rules);
    }

    @Override
    public <P> RuleBuilderProperty<T, P> ruleFor(Function<T, P> function) {
        RuleBuilderPropertyImpl<T, P> rule = new RuleBuilderPropertyImpl<T, P>(function);
        this.rules.add(rule);
        return rule;
    }

    @Override
    public <P> RuleBuilderProperty<T, P> ruleFor(String fieldName, Function<T, P> function) {
        RuleBuilderPropertyImpl<T, P> rule = new RuleBuilderPropertyImpl<T, P>(fieldName, function);
        this.rules.add(rule);
        return rule;
    }

    @Override
    public <P> RuleBuilderCollection<T, P> ruleForEach(String fieldName, Function<T, Collection<P>> function) {
        RuleBuilderCollectionImpl<T, P> rule = new RuleBuilderCollectionImpl<T, P>(fieldName, function);
        this.rules.add(rule);
        return rule;
    }

    @Override
    public <P> RuleBuilderCollection<T, P> ruleForEach(Function<T, Collection<P>> function) {
        RuleBuilderCollectionImpl<T, P> rule = new RuleBuilderCollectionImpl<T, P>(function);
        this.rules.add(rule);
        return rule;
    }

    private static class Initializer<T> {
        private final AtomicReference<Boolean> atomicReference = new AtomicReference<Boolean>(Boolean.FALSE);
        private final Validator<T> validator;

        Initializer(Validator<T> validator) {
            this.validator = validator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void init() {
            if (this.isNotInitialized()) {
                AtomicReference<Boolean> atomicReference = this.atomicReference;
                synchronized (atomicReference) {
                    if (this.isNotInitialized()) {
                        this.validator.rules();
                        Boolean oldValue = this.atomicReference.get();
                        Boolean newValue = Boolean.TRUE;
                        this.atomicReference.compareAndSet(oldValue, newValue);
                    }
                }
            }
        }

        private boolean isNotInitialized() {
            return Boolean.FALSE.equals(this.atomicReference.get());
        }
    }
}

