/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.runner;

import com.github.mkolisnyk.cucumber.runner.ExtendedScenarioOutlineRunner;
import cucumber.runtime.CucumberException;
import cucumber.runtime.Runtime;
import cucumber.runtime.junit.ExecutionUnitRunner;
import cucumber.runtime.junit.FeatureRunner;
import cucumber.runtime.junit.JUnitReporter;
import cucumber.runtime.model.CucumberFeature;
import cucumber.runtime.model.CucumberScenario;
import cucumber.runtime.model.CucumberScenarioOutline;
import cucumber.runtime.model.CucumberTagStatement;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.internal.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;

public class ExtendedFeatureRunner
extends FeatureRunner {
    private final List<ParentRunner> children = new ArrayList<ParentRunner>();
    private final int retryCount = 3;
    private int failedAttempts = 0;
    private int scenarioCount = 0;
    private Runtime runtime;
    private CucumberFeature cucumberFeature;
    private JUnitReporter jUnitReporter;

    public ExtendedFeatureRunner(CucumberFeature cucumberFeatureValue, Runtime runtimeValue, JUnitReporter jUnitReporterValue) throws InitializationError {
        super(cucumberFeatureValue, runtimeValue, jUnitReporterValue);
        this.cucumberFeature = cucumberFeatureValue;
        this.runtime = runtimeValue;
        this.jUnitReporter = jUnitReporterValue;
        this.buildFeatureElementRunners();
    }

    private void buildFeatureElementRunners() {
        for (CucumberTagStatement cucumberTagStatement : this.cucumberFeature.getFeatureElements()) {
            try {
                Object featureElementRunner = cucumberTagStatement instanceof CucumberScenario ? new ExecutionUnitRunner(this.runtime, (CucumberScenario)cucumberTagStatement, this.jUnitReporter) : new ExtendedScenarioOutlineRunner(this.runtime, (CucumberScenarioOutline)cucumberTagStatement, this.jUnitReporter);
                this.children.add((ParentRunner)featureElementRunner);
            }
            catch (InitializationError e) {
                throw new CucumberException("Failed to create scenario runner", (Throwable)e);
            }
        }
    }

    public final Runtime getRuntime() {
        return this.runtime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runChild(ParentRunner child, RunNotifier notifier) {
        System.out.println("Running Feature child (scenario)...");
        notifier.fireTestStarted(child.getDescription());
        try {
            System.out.println("Begin scenario run...");
            child.run(notifier);
            Assert.assertEquals((long)0L, (long)this.getRuntime().exitStatus());
        }
        catch (AssumptionViolatedException e) {
            System.out.println("Scenario AssumptionViolatedException...");
            notifier.fireTestAssumptionFailed(new Failure(child.getDescription(), (Throwable)e));
        }
        catch (Throwable e) {
            System.out.println("Initiating retry...");
            this.retry(notifier, child, e);
        }
        finally {
            System.out.println("Scenario completed..." + this.getRuntime().exitStatus());
            notifier.fireTestFinished(child.getDescription());
        }
        ++this.scenarioCount;
        this.failedAttempts = 0;
    }

    public void retry(RunNotifier notifier, ParentRunner child, Throwable currentThrowable) {
        Throwable caughtThrowable = currentThrowable;
        ExecutionUnitRunner featureElementRunner = null;
        boolean failed = true;
        Class<?> clazz = child.getClass();
        System.out.println("Current class is: " + clazz.getCanonicalName());
        CucumberTagStatement cucumberTagStatement = (CucumberTagStatement)this.cucumberFeature.getFeatureElements().get(this.scenarioCount);
        if (cucumberTagStatement instanceof CucumberScenarioOutline) {
            return;
        }
        while (3 > this.failedAttempts) {
            try {
                featureElementRunner = new ExecutionUnitRunner(this.runtime, (CucumberScenario)cucumberTagStatement, this.jUnitReporter);
                featureElementRunner.run(notifier);
                Assert.assertEquals((long)0L, (long)this.getRuntime().exitStatus());
                failed = false;
                break;
            }
            catch (Throwable t) {
                ++this.failedAttempts;
                caughtThrowable = t;
                this.getRuntime().getErrors().clear();
            }
        }
        if (failed) {
            notifier.fireTestFailure(new Failure(featureElementRunner.getDescription(), caughtThrowable));
        }
    }

    protected List<ParentRunner> getChildren() {
        return this.children;
    }

    protected Description describeChild(ParentRunner child) {
        return child.getDescription();
    }
}

