/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.runner;

import cucumber.runtime.Runtime;
import cucumber.runtime.junit.ExecutionUnitRunner;
import cucumber.runtime.junit.JUnitReporter;
import cucumber.runtime.model.CucumberExamples;
import cucumber.runtime.model.CucumberScenario;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.internal.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;

public class ExtendedExamplesRunner
extends Suite {
    private static final int DEFAULT_RETRY_COUNT = 3;
    private int retryCount = 3;
    private Runtime runtime;
    private final CucumberExamples cucumberExamples;
    private Description description;
    private JUnitReporter jUnitReporter;
    private int exampleCount = 0;
    private static List<Runner> runners;
    private static List<CucumberScenario> exampleScenarios;

    protected ExtendedExamplesRunner(Runtime runtimeValue, CucumberExamples cucumberExamplesValue, JUnitReporter jUnitReporterValue) throws InitializationError {
        super(ExtendedExamplesRunner.class, ExtendedExamplesRunner.buildRunners(runtimeValue, cucumberExamplesValue, jUnitReporterValue));
        this.cucumberExamples = cucumberExamplesValue;
        this.jUnitReporter = jUnitReporterValue;
        this.runtime = runtimeValue;
    }

    private static List<Runner> buildRunners(Runtime runtime, CucumberExamples cucumberExamples, JUnitReporter jUnitReporter) {
        runners = new ArrayList<Runner>();
        exampleScenarios = cucumberExamples.createExampleScenarios();
        for (CucumberScenario scenario : exampleScenarios) {
            try {
                ExecutionUnitRunner exampleScenarioRunner = new ExecutionUnitRunner(runtime, scenario, jUnitReporter);
                runners.add((Runner)exampleScenarioRunner);
            }
            catch (InitializationError initializationError) {
                initializationError.printStackTrace();
            }
        }
        return runners;
    }

    public final Runtime getRuntime() {
        return this.runtime;
    }

    protected String getName() {
        return this.cucumberExamples.getExamples().getKeyword() + ": " + this.cucumberExamples.getExamples().getName();
    }

    public Description getDescription() {
        if (this.description == null) {
            this.description = Description.createSuiteDescription((String)this.getName(), (Serializable)this.cucumberExamples.getExamples(), (Annotation[])new Annotation[0]);
            for (Runner child : this.getChildren()) {
                this.description.addChild(this.describeChild(child));
            }
        }
        return this.description;
    }

    public void run(RunNotifier notifier) {
        this.jUnitReporter.examples(this.cucumberExamples.getExamples());
        super.run(notifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runChild(Runner runner, RunNotifier notifier) {
        ExecutionUnitRunner featureElementRunner = null;
        featureElementRunner = (ExecutionUnitRunner)runner;
        try {
            featureElementRunner.run(notifier);
            Assert.assertEquals((long)0L, (long)this.getRuntime().exitStatus());
        }
        catch (AssumptionViolatedException e) {
            System.out.println("Scenario AssumptionViolatedException...");
            notifier.fireTestAssumptionFailed(new Failure(runner.getDescription(), (Throwable)e));
        }
        catch (Throwable e) {
            System.out.println("Initiating retry...");
            this.retry(notifier, (ParentRunner)featureElementRunner, e);
        }
        finally {
            System.out.println("Scenario completed..." + this.getRuntime().exitStatus());
            notifier.fireTestFinished(runner.getDescription());
        }
        ++this.exampleCount;
    }

    public void retry(RunNotifier notifier, ParentRunner child, Throwable currentThrowable) {
        Throwable caughtThrowable = currentThrowable;
        CucumberScenario scenario = exampleScenarios.get(this.exampleCount);
        ExecutionUnitRunner featureElementRunner = null;
        boolean failed = true;
        System.out.println("Retrying...");
        for (int failedAttempts = 0; this.retryCount > failedAttempts; ++failedAttempts) {
            try {
                featureElementRunner = new ExecutionUnitRunner(this.runtime, scenario, this.jUnitReporter);
                featureElementRunner.run(notifier);
                Assert.assertEquals((long)0L, (long)this.getRuntime().exitStatus());
                failed = false;
                break;
            }
            catch (Throwable t) {
                caughtThrowable = t;
                this.getRuntime().getErrors().clear();
                continue;
            }
        }
        if (failed) {
            notifier.fireTestFailure(new Failure(featureElementRunner.getDescription(), caughtThrowable));
        }
    }
}

