/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.spring.batch.inmemory;

import com.github.marschall.spring.batch.inmemory.EmptyResultSet;
import com.github.marschall.spring.batch.inmemory.NullConnection;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

class NullStatement
implements Statement {
    private static final Set<Integer> FETCH_DIRECTIONS = Set.of(Integer.valueOf(1000), Integer.valueOf(1001), Integer.valueOf(1002));
    static final int DEFAULT_FETCH_SIZE = 100;
    private boolean closed;
    private final NullConnection connection;
    private final List<ResultSet> closeables;
    final int resultSetType;
    final int resultSetConcurrency;
    final int resultSetHoldability;
    private int queryTimeout;
    int fetchSize;
    int fetchDirection;

    NullStatement(NullConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this.connection = connection;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
        this.queryTimeout = 0;
        this.fetchSize = 100;
        this.fetchDirection = 1000;
        this.closed = false;
        this.closeables = new ArrayList<ResultSet>();
    }

    static void validateFetchDirection(int direction) throws SQLException {
        if (!FETCH_DIRECTIONS.contains(direction)) {
            throw new SQLException("unsupported direction: " + direction);
        }
    }

    void closedCheck() throws SQLException {
        if (this.closed) {
            throw new SQLException("closed result set");
        }
    }

    ResultSet addCloseable(ResultSet closable) {
        this.closeables.add(closable);
        return closable;
    }

    void removeCloseable(ResultSet closable) {
        this.closeables.remove(closable);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.closedCheck();
        if (this.isWrapperFor(iface)) {
            return iface.cast(this);
        }
        throw new SQLException("unsupported interface: " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.closedCheck();
        return iface == Statement.class;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.closedCheck();
        return this.addCloseable(new EmptyResultSet(this, this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability, this.fetchSize, this.fetchDirection));
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.closedCheck();
        return 0;
    }

    @Override
    public void close() throws SQLException {
        this.connection.removeCloseable(this);
        ArrayList<ResultSet> toClose = new ArrayList<ResultSet>(this.closeables);
        for (ResultSet resultSet : toClose) {
            resultSet.close();
        }
        this.closed = true;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
    }

    @Override
    public int getMaxRows() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.closedCheck();
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.closedCheck();
        if (seconds < 0) {
            throw new SQLException("query timeout must not be negative, was: " + seconds);
        }
        this.queryTimeout = seconds;
    }

    @Override
    public void cancel() throws SQLException {
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void setCursorName(String name) throws SQLException {
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return false;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return null;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return 0;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.closedCheck();
        NullStatement.validateFetchDirection(direction);
        this.fetchDirection = direction;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.closedCheck();
        return this.fetchDirection;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.closedCheck();
        if (rows > 0) {
            this.fetchSize = rows;
        } else if (rows == 0) {
            this.fetchSize = 100;
        } else {
            throw new SQLException("negative fetch size: " + rows);
        }
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.closedCheck();
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.closedCheck();
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.closedCheck();
        return this.resultSetType;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
    }

    @Override
    public void clearBatch() throws SQLException {
        this.closedCheck();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.closedCheck();
        return new int[]{0};
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.closedCheck();
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return null;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return 0;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return false;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.closedCheck();
        return this.resultSetHoldability;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        return Statement.super.getLargeUpdateCount();
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        Statement.super.setLargeMaxRows(max);
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        return Statement.super.getLargeMaxRows();
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        this.closedCheck();
        return new long[]{0L};
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        this.closedCheck();
        return 0L;
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return Statement.super.executeLargeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return Statement.super.executeLargeUpdate(sql, columnIndexes);
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        return Statement.super.executeLargeUpdate(sql, columnNames);
    }

    @Override
    public String enquoteLiteral(String val) throws SQLException {
        return Statement.super.enquoteLiteral(val);
    }

    @Override
    public String enquoteIdentifier(String identifier, boolean alwaysQuote) throws SQLException {
        return Statement.super.enquoteIdentifier(identifier, alwaysQuote);
    }

    @Override
    public boolean isSimpleIdentifier(String identifier) throws SQLException {
        return Statement.super.isSimpleIdentifier(identifier);
    }

    @Override
    public String enquoteNCharLiteral(String val) throws SQLException {
        return Statement.super.enquoteNCharLiteral(val);
    }
}

