/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.spring.batch.inmemory;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.lang.Nullable;

public final class NullJobRepository
implements JobRepository {
    private static final Log LOGGER = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final AtomicLong JOB_INSTANCE_ID = new AtomicLong();
    private static final AtomicLong JOB_EXECUTION_ID = new AtomicLong();
    private static final AtomicLong STEP_EXECUTION_ID = new AtomicLong();

    public boolean isJobInstanceExists(String jobName, JobParameters jobParameters) {
        Objects.requireNonNull(jobName, "jobName");
        Objects.requireNonNull(jobParameters, "jobParameters");
        return false;
    }

    public JobInstance createJobInstance(String jobName, JobParameters jobParameters) {
        Objects.requireNonNull(jobName, "jobName");
        Objects.requireNonNull(jobParameters, "jobParameters");
        JobInstance jobInstance = new JobInstance(Long.valueOf(JOB_INSTANCE_ID.incrementAndGet()), jobName);
        jobInstance.incrementVersion();
        return jobInstance;
    }

    public JobExecution createJobExecution(JobInstance jobInstance, JobParameters jobParameters, String jobConfigurationLocation) {
        Objects.requireNonNull(jobInstance, "jobInstance");
        Objects.requireNonNull(jobParameters, "jobParameters");
        JobExecution jobExecution = new JobExecution(jobInstance, Long.valueOf(JOB_EXECUTION_ID.incrementAndGet()), jobParameters, jobConfigurationLocation);
        jobExecution.setLastUpdated(new Date());
        jobExecution.incrementVersion();
        return jobExecution;
    }

    public JobExecution createJobExecution(String jobName, JobParameters jobParameters) {
        Objects.requireNonNull(jobName, "jobName");
        Objects.requireNonNull(jobParameters, "jobParameters");
        JobInstance jobInstance = new JobInstance(Long.valueOf(JOB_INSTANCE_ID.incrementAndGet()), jobName);
        jobInstance.incrementVersion();
        JobExecution jobExecution = new JobExecution(jobInstance, Long.valueOf(JOB_EXECUTION_ID.incrementAndGet()), jobParameters, null);
        jobExecution.incrementVersion();
        jobExecution.setLastUpdated(new Date());
        return jobExecution;
    }

    public void update(JobExecution jobExecution) {
        Objects.requireNonNull(jobExecution, "jobExecution");
        Objects.requireNonNull(jobExecution.getJobId(), "jobExecution.getJobId()");
        Objects.requireNonNull(jobExecution.getId(), "jobExecution.getId()");
        jobExecution.setLastUpdated(new Date());
        jobExecution.incrementVersion();
    }

    public void add(StepExecution stepExecution) {
        NullJobRepository.validateStepExecution(stepExecution);
        stepExecution.setId(Long.valueOf(STEP_EXECUTION_ID.incrementAndGet()));
        stepExecution.setLastUpdated(new Date());
        stepExecution.incrementVersion();
        this.checkForInterruption(stepExecution);
    }

    public void addAll(Collection<StepExecution> stepExecutions) {
        for (StepExecution stepExecution : stepExecutions) {
            this.add(stepExecution);
        }
    }

    public void update(StepExecution stepExecution) {
        NullJobRepository.validateStepExecution(stepExecution);
        Objects.requireNonNull(stepExecution.getId(), "StepExecution must already be saved (have an id assigned)");
        stepExecution.setLastUpdated(new Date());
        stepExecution.incrementVersion();
        this.checkForInterruption(stepExecution);
    }

    public void updateExecutionContext(StepExecution stepExecution) {
        NullJobRepository.validateStepExecution(stepExecution);
    }

    public void updateExecutionContext(JobExecution jobExecution) {
    }

    @Nullable
    public StepExecution getLastStepExecution(JobInstance jobInstance, String stepName) {
        return null;
    }

    public int getStepExecutionCount(JobInstance jobInstance, String stepName) {
        return 0;
    }

    @Nullable
    public JobExecution getLastJobExecution(String jobName, JobParameters jobParameters) {
        return null;
    }

    private static void validateStepExecution(StepExecution stepExecution) {
        Objects.requireNonNull(stepExecution, "StepExecution cannot be null.");
        Objects.requireNonNull(stepExecution.getStepName(), "StepExecution's step name cannot be null.");
        Objects.requireNonNull(stepExecution.getJobExecutionId(), "StepExecution must belong to persisted JobExecution");
    }

    private void checkForInterruption(StepExecution stepExecution) {
        JobExecution jobExecution = stepExecution.getJobExecution();
        if (jobExecution.isStopping()) {
            LOGGER.info((Object)("Parent JobExecution " + jobExecution.getId() + " is stopped, so passing message on to StepExecution " + stepExecution.getId()));
            stepExecution.setTerminateOnly();
        }
    }
}

