/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.spring.batch.inmemory;

import com.github.marschall.spring.batch.inmemory.NullConnection;
import com.github.marschall.spring.batch.inmemory.NullConnectionBuilder;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ConnectionBuilder;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;

public final class NullDataSource
implements DataSource {
    private volatile int loginTimeout = 0;

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return new NullConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return new NullConnection(username);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        if (seconds <= 0) {
            throw new IllegalArgumentException();
        }
        this.loginTimeout = seconds;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public ConnectionBuilder createConnectionBuilder() throws SQLException {
        return new NullConnectionBuilder();
    }
}

