/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.spring.batch.inmemory;

import com.github.marschall.spring.batch.inmemory.NullJobExplorer;
import com.github.marschall.spring.batch.inmemory.NullJobRepository;
import java.util.Objects;
import org.springframework.batch.core.configuration.annotation.BatchConfigurer;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.support.SimpleJobLauncher;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;

@Component
public class NullBatchConfigurer
implements BatchConfigurer {
    private final JobExplorer jobExplorer;
    private final JobRepository jobRepository;
    private final PlatformTransactionManager transactionManager;

    public NullBatchConfigurer(PlatformTransactionManager transactionManager) {
        Objects.requireNonNull(transactionManager, "transactionManager");
        this.transactionManager = transactionManager;
        this.jobExplorer = new NullJobExplorer();
        this.jobRepository = new NullJobRepository();
    }

    public JobExplorer getJobExplorer() {
        return this.jobExplorer;
    }

    public JobRepository getJobRepository() {
        return this.jobRepository;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public JobLauncher getJobLauncher() throws Exception {
        SimpleJobLauncher jobLauncher = new SimpleJobLauncher();
        jobLauncher.setJobRepository(this.jobRepository);
        jobLauncher.afterPropertiesSet();
        return jobLauncher;
    }
}

