/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.spring.batch.inmemory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.Entity;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.lang.Nullable;

public final class InMemoryJobStorage {
    private static final ExecutionContext EMPTY_EXECUTION_CONTEXT = new ExecutionContext();
    private final Map<Long, JobInstance> instancesById = new HashMap<Long, JobInstance>();
    private final Map<String, List<JobInstanceAndParameters>> jobInstancesByName = new HashMap<String, List<JobInstanceAndParameters>>();
    private final Map<Long, JobExecution> jobExecutionsById = new HashMap<Long, JobExecution>();
    private final Map<Long, JobExecutions> jobInstanceToExecutions;
    private final Map<Long, ExecutionContext> jobExecutionContextsById = new HashMap<Long, ExecutionContext>();
    private final Map<Long, ExecutionContext> stepExecutionContextsById = new HashMap<Long, ExecutionContext>();
    private final Map<Long, Map<Long, StepExecution>> stepExecutionsByJobExecutionId;
    private final Map<StepExecutionKey, StepExecutionStatistics> stepExecutionStatistics;
    private final ReadWriteLock instanceLock;
    private long nextJobInstanceId = 1L;
    private long nextJobExecutionId = 1L;
    private long nextStepExecutionId = 1L;

    public InMemoryJobStorage() {
        this.jobInstanceToExecutions = new HashMap<Long, JobExecutions>();
        this.stepExecutionsByJobExecutionId = new HashMap<Long, Map<Long, StepExecution>>();
        this.stepExecutionStatistics = new HashMap<StepExecutionKey, StepExecutionStatistics>();
        this.instanceLock = new ReentrantReadWriteLock();
    }

    private List<Long> getExecutionIds(JobInstance jobInstance) {
        JobExecutions jobExecutions = this.jobInstanceToExecutions.get(jobInstance.getId());
        if (jobExecutions != null) {
            return jobExecutions.getJobExecutionIds();
        }
        return List.of();
    }

    private JobExecutions getJobExecutionsUnlocked(JobInstance jobInstance) {
        return this.jobInstanceToExecutions.get(jobInstance.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JobInstance createJobInstance(String jobName, JobParameters jobParameters) {
        Objects.requireNonNull(jobName, "jobName");
        Objects.requireNonNull(jobParameters, "jobParameters");
        Lock writeLock = this.instanceLock.writeLock();
        writeLock.lock();
        try {
            this.verifyNoJobInstanceUnlocked(jobName, jobParameters);
            JobInstance jobInstance = this.createJobInstanceUnlocked(jobName, jobParameters);
            return jobInstance;
        }
        finally {
            writeLock.unlock();
        }
    }

    private void verifyNoJobInstanceUnlocked(String jobName, JobParameters jobParameters) {
        JobInstance jobInstance = this.getJobInstanceUnlocked(jobName, jobParameters);
        if (jobInstance != null) {
            throw new IllegalStateException("JobInstance must not already exist");
        }
    }

    private JobInstance createJobInstanceUnlocked(String jobName, JobParameters jobParameters) {
        List<JobInstanceAndParameters> instancesAndParameters = this.jobInstancesByName.get(jobName);
        JobInstance jobInstance = new JobInstance(Long.valueOf(this.nextJobInstanceId++), jobName);
        jobInstance.incrementVersion();
        this.instancesById.put(jobInstance.getId(), jobInstance);
        if (instancesAndParameters == null) {
            instancesAndParameters = new ArrayList<JobInstanceAndParameters>();
            this.jobInstancesByName.put(jobName, instancesAndParameters);
        }
        Map<String, JobParameter> identifyingJoParameters = jobParameters.getParameters().entrySet().stream().filter(entry -> ((JobParameter)entry.getValue()).isIdentifying()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        instancesAndParameters.add(new JobInstanceAndParameters(jobInstance, identifyingJoParameters));
        return jobInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JobExecution createJobExecution(JobInstance jobInstance, JobParameters jobParameters, String jobConfigurationLocation) {
        Lock writeLock = this.instanceLock.writeLock();
        writeLock.lock();
        try {
            Long jobExecutionId = this.nextJobExecutionId++;
            JobExecution jobExecution = new JobExecution(jobInstance, jobExecutionId, jobParameters, jobConfigurationLocation);
            jobExecution.setLastUpdated(new Date());
            jobExecution.incrementVersion();
            this.jobExecutionsById.put(jobExecutionId, InMemoryJobStorage.copyJobExecution(jobExecution));
            this.storeJobExecutionContextUnlocked(jobExecution);
            this.mapJobExecutionUnlocked(jobInstance, jobExecution);
            JobExecution jobExecution2 = jobExecution;
            return jobExecution2;
        }
        finally {
            writeLock.unlock();
        }
    }

    private void mapJobExecutionUnlocked(JobInstance jobInstance, JobExecution jobExecution) {
        JobExecutions jobExecutions = this.jobInstanceToExecutions.computeIfAbsent(jobInstance.getId(), jobInstanceId -> new JobExecutions());
        jobExecutions.addJobExecutionId(jobExecution.getId());
    }

    private void storeJobExecutionContextUnlocked(JobExecution jobExecution) {
        ExecutionContext executionContext = jobExecution.getExecutionContext();
        if (executionContext.isEmpty()) {
            this.jobExecutionContextsById.put(jobExecution.getId(), EMPTY_EXECUTION_CONTEXT);
        } else {
            this.jobExecutionContextsById.put(jobExecution.getId(), InMemoryJobStorage.copyExecutionContext(executionContext));
        }
    }

    private ExecutionContext loadJobExecutionContextUnlocked(JobExecution jobExecution) {
        ExecutionContext executionContext = this.jobExecutionContextsById.get(jobExecution.getId());
        if (!executionContext.isEmpty()) {
            return InMemoryJobStorage.copyExecutionContext(executionContext);
        }
        return null;
    }

    private void setJobExecutionContextUnlocked(JobExecution jobExecution) {
        ExecutionContext executionContext = this.loadJobExecutionContextUnlocked(jobExecution);
        if (executionContext != null) {
            jobExecution.setExecutionContext(executionContext);
        }
    }

    private void storeStepExecutionContextUnlocked(StepExecution stepExecution) {
        ExecutionContext executionContext = stepExecution.getExecutionContext();
        if (executionContext.isEmpty()) {
            this.stepExecutionContextsById.put(stepExecution.getId(), EMPTY_EXECUTION_CONTEXT);
        } else {
            this.stepExecutionContextsById.put(stepExecution.getId(), InMemoryJobStorage.copyExecutionContext(executionContext));
        }
    }

    private ExecutionContext loadStepExecutionContextUnlocked(StepExecution stepExecution) {
        ExecutionContext executionContext = this.stepExecutionContextsById.get(stepExecution.getId());
        if (!executionContext.isEmpty()) {
            return InMemoryJobStorage.copyExecutionContext(executionContext);
        }
        return null;
    }

    private void setStepExecutionContextUnlocked(StepExecution stepExecution) {
        ExecutionContext executionContext = this.loadStepExecutionContextUnlocked(stepExecution);
        if (executionContext != null) {
            stepExecution.setExecutionContext(executionContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JobExecution createJobExecution(String jobName, JobParameters jobParameters) throws JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException {
        Lock writeLock = this.instanceLock.writeLock();
        writeLock.lock();
        try {
            JobInstance jobInstance = this.getJobInstanceUnlocked(jobName, jobParameters);
            ExecutionContext executionContext = null;
            if (jobInstance != null) {
                JobExecutions jobExecutions = this.getJobExecutionsUnlocked(jobInstance);
                if (jobExecutions == null) {
                    throw new IllegalStateException("Cannot find any job execution for job instance: " + jobInstance);
                }
                if (jobExecutions.hasBlockingJobExecutionId()) {
                    this.reportBlockingJobExecution(jobInstance, jobParameters, jobExecutions);
                } else {
                    Long lastJobExecutionId = jobExecutions.getLastJobExecutionId();
                    JobExecution lastJobExecution = this.jobExecutionsById.get(lastJobExecutionId);
                    ExecutionContext lastExecutionContext = this.jobExecutionContextsById.get(lastJobExecution.getId());
                    if (!lastExecutionContext.isEmpty()) {
                        executionContext = InMemoryJobStorage.copyExecutionContext(lastExecutionContext);
                    }
                }
            } else {
                jobInstance = this.createJobInstanceUnlocked(jobName, jobParameters);
            }
            JobExecution jobExecution = new JobExecution(jobInstance, jobParameters, null);
            if (executionContext != null) {
                jobExecution.setExecutionContext(executionContext);
            }
            jobExecution.setLastUpdated(new Date());
            this.saveJobExecutionUnlocked(jobExecution);
            this.storeJobExecutionContextUnlocked(jobExecution);
            this.mapJobExecutionUnlocked(jobInstance, jobExecution);
            JobExecution jobExecution2 = jobExecution;
            return jobExecution2;
        }
        finally {
            writeLock.unlock();
        }
    }

    private void reportBlockingJobExecution(JobInstance jobInstance, JobParameters jobParameters, JobExecutions jobExecutions) throws JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException {
        List<Long> executionIds = jobExecutions.getJobExecutionIds();
        if (executionIds.isEmpty()) {
            throw new IllegalStateException("Cannot find any job execution for job instance: " + jobInstance);
        }
        for (Long executionId : executionIds) {
            JobExecution jobExecution = this.jobExecutionsById.get(executionId);
            if (jobExecution.isRunning() || jobExecution.isStopping()) {
                throw new JobExecutionAlreadyRunningException("A job execution for this job is already running: " + jobInstance);
            }
            BatchStatus status = jobExecution.getStatus();
            if (status == BatchStatus.UNKNOWN) {
                throw new JobRestartException("Cannot restart job from UNKNOWN status. The last execution ended with a failure that could not be rolled back, so it may be dangerous to proceed. Manual intervention is probably necessary.");
            }
            if (status != BatchStatus.COMPLETED && status != BatchStatus.ABANDONED || !InMemoryJobStorage.hasIdentifyingParameter(jobExecution)) continue;
            throw new JobInstanceAlreadyCompleteException("A job instance already exists and is complete for parameters=" + jobParameters + ".  If you want to run this job again, change the parameters.");
        }
    }

    private static boolean hasIdentifyingParameter(JobExecution jobExecution) {
        JobParameters jobParameters = jobExecution.getJobParameters();
        if (jobParameters.isEmpty()) {
            return false;
        }
        Map parameterMap = jobParameters.getParameters();
        for (JobParameter jobParameter : parameterMap.values()) {
            if (!jobParameter.isIdentifying()) continue;
            return true;
        }
        return false;
    }

    private void saveJobExecutionUnlocked(JobExecution jobExecution) {
        long jobExecutionId = this.nextJobExecutionId++;
        jobExecution.setId(Long.valueOf(jobExecutionId));
        jobExecution.incrementVersion();
        this.jobExecutionsById.put(jobExecutionId, InMemoryJobStorage.copyJobExecution(jobExecution));
    }

    private JobExecution getLastJobExecutionUnlocked(JobInstance jobInstance) {
        JobExecutions jobExecutions = this.getJobExecutionsUnlocked(jobInstance);
        if (jobExecutions != null) {
            Long lastExecutionId = jobExecutions.getLastJobExecutionId();
            JobExecution lastJobExecution = this.jobExecutionsById.get(lastExecutionId);
            if (lastJobExecution != null) {
                return this.copyJobExecutionWithDependencies(lastJobExecution);
            }
            return null;
        }
        return null;
    }

    private JobExecution copyJobExecutionWithDependencies(JobExecution jobExecution) {
        JobExecution copy = InMemoryJobStorage.copyJobExecution(jobExecution);
        this.setJobExecutionContextUnlocked(copy);
        this.loadStepExecutionsUnlocked(copy);
        for (StepExecution stepExecution : copy.getStepExecutions()) {
            this.setStepExecutionContextUnlocked(stepExecution);
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JobExecution getLastJobExecution(JobInstance jobInstance) {
        Lock readLock = this.instanceLock.readLock();
        readLock.lock();
        try {
            JobExecution jobExecution = this.getLastJobExecutionUnlocked(jobInstance);
            return jobExecution;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JobExecution getLastJobExecution(String jobName, JobParameters jobParameters) {
        Lock readLock = this.instanceLock.readLock();
        readLock.lock();
        try {
            JobInstance jobInstance = this.getJobInstanceUnlocked(jobName, jobParameters);
            if (jobInstance == null) {
                JobExecution jobExecution = null;
                return jobExecution;
            }
            JobExecution jobExecution = this.getLastJobExecutionUnlocked(jobInstance);
            return jobExecution;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<JobExecution> findRunningJobExecutions(String jobName) {
        Lock readLock = this.instanceLock.readLock();
        readLock.lock();
        try {
            List<JobInstanceAndParameters> jobInstancesAndParameters = this.jobInstancesByName.get(jobName);
            if (jobInstancesAndParameters == null) {
                Set<JobExecution> set = Set.of();
                return set;
            }
            HashSet<JobExecution> runningJobExecutions = new HashSet<JobExecution>();
            for (JobInstanceAndParameters jobInstanceAndParameters : jobInstancesAndParameters) {
                JobExecutions jobExecutions = this.getJobExecutionsUnlocked(jobInstanceAndParameters.getJobInstance());
                if (jobExecutions == null) continue;
                Set<Long> jobExecutionIds = jobExecutions.getBlockingJobExecutionIds();
                for (Long jobExecutionId : jobExecutionIds) {
                    JobExecution jobExecution = this.jobExecutionsById.get(jobExecutionId);
                    if (!jobExecution.isRunning()) continue;
                    runningJobExecutions.add(this.copyJobExecutionWithDependencies(jobExecution));
                }
            }
            HashSet<JobExecution> hashSet = runningJobExecutions;
            return hashSet;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<JobExecution> findJobExecutions(JobInstance jobInstance) {
        Lock readLock = this.instanceLock.readLock();
        readLock.lock();
        try {
            List<Long> jobExecutionIds = this.getExecutionIds(jobInstance);
            ArrayList<JobExecution> jobExecutions = new ArrayList<JobExecution>(jobExecutionIds.size());
            for (Long jobExecutionId : jobExecutionIds) {
                JobExecution jobExecution = this.jobExecutionsById.get(jobExecutionId);
                jobExecutions.add(this.copyJobExecutionWithDependencies(jobExecution));
            }
            jobExecutions.sort(Comparator.comparing(Entity::getId));
            ArrayList<JobExecution> arrayList = jobExecutions;
            return arrayList;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(JobExecution jobExecution) {
        jobExecution.setLastUpdated(new Date());
        this.synchronizeStatus(jobExecution);
        Long id = jobExecution.getId();
        Lock writeLock = this.instanceLock.writeLock();
        writeLock.lock();
        try {
            JobExecution persisted = this.jobExecutionsById.get(id);
            if (persisted == null) {
                throw new IllegalArgumentException("JobExecution must already be saved");
            }
            JobExecution jobExecution2 = jobExecution;
            synchronized (jobExecution2) {
                if (!persisted.getVersion().equals(jobExecution.getVersion())) {
                    throw new OptimisticLockingFailureException("Attempt to update job execution id=" + id + " with wrong version (" + jobExecution.getVersion() + "), where current version is " + persisted.getVersion());
                }
                jobExecution.incrementVersion();
                this.jobExecutionsById.put(id, InMemoryJobStorage.copyJobExecution(jobExecution));
                this.updateBlockingStatusUnlocked(jobExecution);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateJobExecutionContext(JobExecution jobExecution) {
        ExecutionContext jobExecutionContext = jobExecution.getExecutionContext();
        if (jobExecutionContext != null) {
            Lock writeLock = this.instanceLock.writeLock();
            writeLock.lock();
            try {
                this.storeJobExecutionContextUnlocked(jobExecution);
            }
            finally {
                writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void synchronizeStatus(JobExecution jobExecution) {
        Lock readLock = this.instanceLock.readLock();
        readLock.lock();
        try {
            JobExecution presisted = this.jobExecutionsById.get(jobExecution.getId());
            if (presisted.getVersion().intValue() != jobExecution.getVersion().intValue()) {
                jobExecution.upgradeStatus(presisted.getStatus());
                jobExecution.setVersion(presisted.getVersion());
            }
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JobInstance getJobInstance(Long instanceId) {
        Objects.requireNonNull(instanceId, "instanceId");
        Lock readLock = this.instanceLock.readLock();
        readLock.lock();
        try {
            JobInstance jobInstance = this.instancesById.get(instanceId);
            return jobInstance;
        }
        finally {
            readLock.unlock();
        }
    }

    private JobInstance getJobInstanceUnlocked(String jobName, JobParameters jobParameters) {
        List<JobInstanceAndParameters> instancesAndParameters = this.jobInstancesByName.get(jobName);
        if (instancesAndParameters != null) {
            for (JobInstanceAndParameters instanceAndParametes : instancesAndParameters) {
                if (!instanceAndParametes.areIdentifyingJoParametersEqualTo(jobParameters)) continue;
                return instanceAndParametes.getJobInstance();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isJobInstanceExists(String jobName, JobParameters jobParameters) {
        Lock readLock = this.instanceLock.readLock();
        readLock.lock();
        try {
            boolean bl = this.getJobInstanceUnlocked(jobName, jobParameters) != null;
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JobInstance getLastJobInstance(String jobName) {
        Lock readLock = this.instanceLock.readLock();
        readLock.lock();
        try {
            JobInstance jobInstance = this.getLastJobInstanceUnlocked(jobName);
            return jobInstance;
        }
        finally {
            readLock.unlock();
        }
    }

    private JobInstance getLastJobInstanceUnlocked(String jobName) {
        List<JobInstanceAndParameters> jobInstances = this.jobInstancesByName.get(jobName);
        if (jobInstances == null || jobInstances.isEmpty()) {
            return null;
        }
        if (jobInstances.size() == 1) {
            return jobInstances.get(0).getJobInstance();
        }
        return jobInstances.get(jobInstances.size() - 1).getJobInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JobExecution getJobExecution(Long jobExecutionId) {
        Lock readLock = this.instanceLock.readLock();
        readLock.lock();
        try {
            JobExecution jobExecution = this.jobExecutionsById.get(jobExecutionId);
            if (jobExecution != null) {
                JobExecution jobExecution2 = this.copyJobExecutionWithDependencies(jobExecution);
                return jobExecution2;
            }
            JobExecution jobExecution3 = null;
            return jobExecution3;
        }
        finally {
            readLock.unlock();
        }
    }

    List<JobInstance> findJobInstancesByJobName(String jobName, int start, int count) {
        return this.getJobInstancesByNamePattern(jobName, start, count);
    }

    List<JobInstance> getJobInstances(String jobName, int start, int count) {
        boolean exactPattern = InMemoryJobStorage.isExactPattern(jobName);
        if (exactPattern) {
            return this.getJobInstancesByNameExact(jobName, start, count);
        }
        return this.getJobInstancesByNamePattern(jobName, start, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<JobInstance> getJobInstancesByNameExact(String jobName, int start, int count) {
        Lock readLock = this.instanceLock.readLock();
        readLock.lock();
        try {
            if (start == 0 && count == 1) {
                JobInstance lastJobInstance = this.getLastJobInstanceUnlocked(jobName);
                if (lastJobInstance != null) {
                    List<JobInstance> list = List.of(lastJobInstance);
                    return list;
                }
                List<JobInstance> list = List.of();
                return list;
            }
            List<JobInstanceAndParameters> jobInstances = this.jobInstancesByName.get(jobName);
            if (jobInstances == null || jobInstances.isEmpty()) {
                List<JobInstance> list = List.of();
                return list;
            }
            List<JobInstance> list = jobInstances.stream().map(JobInstanceAndParameters::getJobInstance).sorted(Comparator.comparingLong(JobInstance::getInstanceId)).skip(start).limit(count).collect(Collectors.toList());
            return list;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<JobInstance> getJobInstancesByNamePattern(String jobName, int start, int count) {
        Pattern pattern = Pattern.compile(jobName.replaceAll("\\*", ".*"));
        ArrayList<JobInstance> jobInstancesUnstorted = new ArrayList<JobInstance>();
        Lock readLock = this.instanceLock.readLock();
        readLock.lock();
        try {
            for (Map.Entry<String, List<JobInstanceAndParameters>> entries : this.jobInstancesByName.entrySet()) {
                if (!pattern.matcher(entries.getKey()).matches()) continue;
                for (JobInstanceAndParameters jobInstanceAndParameters : entries.getValue()) {
                    jobInstancesUnstorted.add(jobInstanceAndParameters.getJobInstance());
                }
            }
        }
        finally {
            readLock.unlock();
        }
        return jobInstancesUnstorted.stream().sorted(Comparator.comparingLong(JobInstance::getInstanceId)).skip(start).limit(count).collect(Collectors.toList());
    }

    private static boolean isExactPattern(String s) {
        return s.indexOf(42) == -1 && s.indexOf(95) == -1;
    }

    List<String> getJobNames() {
        ArrayList<Object> jobNames = new ArrayList();
        Lock readLock = this.instanceLock.readLock();
        readLock.lock();
        try {
            jobNames = new ArrayList<String>(this.jobInstancesByName.keySet());
        }
        finally {
            readLock.unlock();
        }
        jobNames.sort(null);
        return jobNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getJobInstanceCount(String jobName) throws NoSuchJobException {
        Lock readLock = this.instanceLock.readLock();
        readLock.lock();
        try {
            List<JobInstanceAndParameters> instancesAndParameters = this.jobInstancesByName.get(jobName);
            if (instancesAndParameters == null) {
                throw new NoSuchJobException("No job instances for job name " + jobName + " were found");
            }
            int n = instancesAndParameters.size();
            return n;
        }
        finally {
            readLock.unlock();
        }
    }

    private void loadStepExecutionsUnlocked(JobExecution jobExecution) {
        Long jobExecutionId = jobExecution.getId();
        Map<Long, StepExecution> executions = this.stepExecutionsByJobExecutionId.get(jobExecutionId);
        if (executions == null || executions.isEmpty()) {
            return;
        }
        ArrayList<StepExecution> stepExecutions = new ArrayList<StepExecution>(executions.values());
        stepExecutions.sort(Comparator.comparing(Entity::getId));
        for (int i = 0; i < stepExecutions.size(); ++i) {
            StepExecution stepExecution = (StepExecution)stepExecutions.get(i);
            InMemoryJobStorage.copyStepExecutionForReading(stepExecution, jobExecution);
        }
    }

    @Nullable
    private Collection<StepExecution> getStepExecutionsOfJobExecutionUnlocked(Long jobExecutionId) {
        Map<Long, StepExecution> stepExecutions = this.stepExecutionsByJobExecutionId.get(jobExecutionId);
        if (stepExecutions != null) {
            return stepExecutions.values();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StepExecution getStepExecution(Long jobExecutionId, Long stepExecutionId) {
        Lock readLock = this.instanceLock.readLock();
        readLock.lock();
        try {
            StepExecution stepExecution = this.getStepExecutionUnlocked(jobExecutionId, stepExecutionId);
            return stepExecution;
        }
        finally {
            readLock.unlock();
        }
    }

    private StepExecution getStepExecutionUnlocked(Long jobExecutionId, Long stepExecutionId) {
        JobExecution jobExecution = this.jobExecutionsById.get(jobExecutionId);
        if (jobExecution == null) {
            return null;
        }
        JobExecution parent = InMemoryJobStorage.copyJobExecution(jobExecution);
        this.setJobExecutionContextUnlocked(parent);
        Map<Long, StepExecution> stepExecutions = this.stepExecutionsByJobExecutionId.get(jobExecution.getId());
        if (stepExecutions == null) {
            return null;
        }
        StepExecution stepExecution = stepExecutions.get(stepExecutionId);
        if (stepExecution != null) {
            return InMemoryJobStorage.copyStepExecutionForReading(stepExecution, jobExecution);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StepExecution getLastStepExecution(JobInstance jobInstance, String stepName) {
        Lock readLock = this.instanceLock.readLock();
        readLock.lock();
        try {
            StepExecutionStatistics statistics = this.stepExecutionStatistics.get(new StepExecutionKey(jobInstance.getInstanceId(), stepName));
            if (statistics == null) {
                StepExecution stepExecution = null;
                return stepExecution;
            }
            Long lastJobExecutionId = statistics.getLastJobExecutionId();
            Long lastStepExecutionId = statistics.getLastStepExecutionId();
            JobExecution latestJobExecution = this.jobExecutionsById.get(lastJobExecutionId);
            StepExecution latestStepExecution = this.stepExecutionsByJobExecutionId.get(lastJobExecutionId).get(lastStepExecutionId);
            if (latestStepExecution != null) {
                StepExecution result = InMemoryJobStorage.copyStepExecutionForReading(latestStepExecution, InMemoryJobStorage.copyJobExecution(latestJobExecution));
                this.setJobExecutionContextUnlocked(result.getJobExecution());
                this.setStepExecutionContextUnlocked(result);
                StepExecution stepExecution = result;
                return stepExecution;
            }
            StepExecution stepExecution = null;
            return stepExecution;
        }
        finally {
            readLock.unlock();
        }
    }

    void addStepExecution(StepExecution stepExecution) {
        Lock writeLock = this.instanceLock.writeLock();
        writeLock.lock();
        try {
            this.addStepExecutionUnlocked(stepExecution);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addStepExecutions(Collection<StepExecution> stepExecutions) {
        Lock writeLock = this.instanceLock.writeLock();
        writeLock.lock();
        try {
            for (StepExecution stepExecution : stepExecutions) {
                this.addStepExecutionUnlocked(stepExecution);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    private void addStepExecutionUnlocked(StepExecution stepExecution) {
        Long jobExecutionId = stepExecution.getJobExecutionId();
        Map<Long, StepExecution> stepExecutions = this.stepExecutionsByJobExecutionId.get(jobExecutionId);
        if (stepExecutions == null) {
            stepExecutions = new HashMap<Long, StepExecution>();
            this.stepExecutionsByJobExecutionId.put(jobExecutionId, stepExecutions);
        }
        JobExecution jobExecution = stepExecution.getJobExecution();
        Long jobInstanceId = jobExecution.getJobInstance().getId();
        Long stepExecutionId = this.nextStepExecutionId++;
        stepExecution.setId(stepExecutionId);
        stepExecution.incrementVersion();
        StepExecution stepExecutionCopy = InMemoryJobStorage.copyStepExecutionForStorage(stepExecution, jobExecution);
        stepExecutions.put(stepExecutionId, stepExecutionCopy);
        this.storeStepExecutionContextUnlocked(stepExecution);
        StepExecutionKey executionKey = new StepExecutionKey(jobInstanceId, stepExecution.getStepName());
        StepExecutionStatistics statistics = this.stepExecutionStatistics.get(executionKey);
        if (statistics == null) {
            this.stepExecutionStatistics.put(executionKey, new StepExecutionStatistics(stepExecutionId, jobExecutionId));
        } else {
            statistics.setLastExecutionIds(stepExecutionId, jobExecutionId);
            statistics.incrementStepExecutionCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateStepExecution(StepExecution stepExecution) {
        Long jobExecutionId = stepExecution.getJobExecutionId();
        Long stepExecutionId = stepExecution.getId();
        Lock writeLock = this.instanceLock.writeLock();
        writeLock.lock();
        try {
            Map<Long, StepExecution> setpExecutions = this.stepExecutionsByJobExecutionId.get(jobExecutionId);
            Objects.requireNonNull(setpExecutions, "step executions for given job execution are expected to be already saved");
            StepExecution persistedExecution = setpExecutions.get(stepExecutionId);
            Objects.requireNonNull(persistedExecution, "step execution is expected to be already saved");
            if (!persistedExecution.getVersion().equals(stepExecution.getVersion())) {
                throw new OptimisticLockingFailureException("Attempt to update step execution id=" + stepExecutionId + " with wrong version (" + stepExecution.getVersion() + "), where current version is " + persistedExecution.getVersion());
            }
            stepExecution.incrementVersion();
            StepExecution stepExecutionCopy = InMemoryJobStorage.copyStepExecutionForStorage(stepExecution, stepExecution.getJobExecution());
            setpExecutions.put(stepExecutionId, stepExecutionCopy);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateStepExecutionContext(StepExecution stepExecution) {
        ExecutionContext stepExecutionContext = stepExecution.getExecutionContext();
        if (stepExecutionContext != null) {
            Lock writeLock = this.instanceLock.writeLock();
            writeLock.lock();
            try {
                this.storeStepExecutionContextUnlocked(stepExecution);
            }
            finally {
                writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int countStepExecutions(JobInstance jobInstance, String stepName) {
        Lock readLock = this.instanceLock.readLock();
        readLock.lock();
        try {
            StepExecutionStatistics statistics = this.stepExecutionStatistics.get(new StepExecutionKey(jobInstance.getInstanceId(), stepName));
            if (statistics != null) {
                int n = statistics.getStepExecutionCount();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            readLock.unlock();
        }
    }

    private static ExecutionContext copyExecutionContext(ExecutionContext original) {
        return new ExecutionContext(original);
    }

    private static JobExecution copyJobExecution(JobExecution original) {
        JobExecution copy = new JobExecution(original.getJobInstance(), original.getId(), original.getJobParameters(), original.getJobConfigurationName());
        copy.setVersion(original.getVersion());
        copy.setStatus(original.getStatus());
        copy.setStartTime(original.getStartTime());
        copy.setCreateTime(original.getCreateTime());
        copy.setEndTime(original.getEndTime());
        copy.setLastUpdated(original.getLastUpdated());
        copy.setExitStatus(original.getExitStatus());
        for (Throwable failureException : original.getFailureExceptions()) {
            copy.addFailureException(failureException);
        }
        return copy;
    }

    private static StepExecution copyStepExecutionForStorage(StepExecution original, JobExecution jobExecution) {
        StepExecution copy = new StepExecution(original.getStepName(), jobExecution);
        copy.setId(original.getId());
        InMemoryJobStorage.copyStepProperties(original, copy);
        return copy;
    }

    private static StepExecution copyStepExecutionForReading(StepExecution original, JobExecution jobExecution) {
        StepExecution copy = new StepExecution(original.getStepName(), jobExecution, original.getId());
        InMemoryJobStorage.copyStepProperties(original, copy);
        return copy;
    }

    private static void copyStepProperties(StepExecution original, StepExecution copy) {
        copy.setVersion(original.getVersion());
        copy.setStatus(original.getStatus());
        copy.setReadCount(original.getReadCount());
        copy.setWriteCount(original.getWriteCount());
        copy.setCommitCount(original.getCommitCount());
        copy.setRollbackCount(original.getRollbackCount());
        copy.setReadSkipCount(original.getReadSkipCount());
        copy.setProcessSkipCount(original.getProcessSkipCount());
        copy.setWriteSkipCount(original.getWriteSkipCount());
        copy.setStartTime(original.getStartTime());
        copy.setEndTime(original.getEndTime());
        copy.setLastUpdated(original.getLastUpdated());
        copy.setExitStatus(original.getExitStatus());
        if (original.isTerminateOnly()) {
            copy.setTerminateOnly();
        }
        copy.setFilterCount(original.getFilterCount());
    }

    private void updateBlockingStatusUnlocked(JobExecution jobExecution) {
        JobExecutions jobExecutions = this.jobInstanceToExecutions.get(jobExecution.getJobInstance().getId());
        if (jobExecutions == null) {
            throw new IllegalStateException("JobExecution must already be registered");
        }
        boolean blocking = InMemoryJobStorage.hasBlockingStatus(jobExecution);
        Long jobExecutionId = jobExecution.getId();
        if (blocking) {
            jobExecutions.addBlockingJobExecutionId(jobExecutionId);
        } else {
            jobExecutions.removeBlockingJobExecutionId(jobExecutionId);
        }
    }

    private static boolean hasBlockingStatus(JobExecution jobExecution) {
        if (jobExecution.isRunning() || jobExecution.isStopping()) {
            return true;
        }
        switch (jobExecution.getStatus()) {
            case UNKNOWN: {
                return true;
            }
            case COMPLETED: 
            case ABANDONED: {
                return InMemoryJobStorage.hasIdentifyingParameter(jobExecution);
            }
        }
        return false;
    }

    public void clear() {
        Lock writeLock = this.instanceLock.writeLock();
        writeLock.lock();
        try {
            this.instancesById.clear();
            this.jobInstancesByName.clear();
            this.jobExecutionsById.clear();
            this.jobExecutionContextsById.clear();
            this.stepExecutionContextsById.clear();
            this.jobInstanceToExecutions.clear();
            this.stepExecutionsByJobExecutionId.clear();
            this.stepExecutionStatistics.clear();
            this.nextJobInstanceId = 1L;
            this.nextJobExecutionId = 1L;
            this.nextStepExecutionId = 1L;
        }
        finally {
            writeLock.unlock();
        }
    }

    static final class JobExecutions {
        private final Set<Long> blockingJobExecutionIds = new HashSet<Long>();
        private final List<Long> jobExecutionIds = new ArrayList<Long>();

        JobExecutions() {
        }

        Set<Long> getBlockingJobExecutionIds() {
            return this.blockingJobExecutionIds;
        }

        void addBlockingJobExecutionId(Long jobExecutionId) {
            this.blockingJobExecutionIds.add(jobExecutionId);
        }

        void addJobExecutionId(Long jobExecutionId) {
            this.jobExecutionIds.add(jobExecutionId);
        }

        void removeBlockingJobExecutionId(Long jobExecutionId) {
            this.blockingJobExecutionIds.remove(jobExecutionId);
        }

        boolean hasBlockingJobExecutionId() {
            return !this.blockingJobExecutionIds.isEmpty();
        }

        Long getLastJobExecutionId() {
            return this.jobExecutionIds.get(this.jobExecutionIds.size() - 1);
        }

        List<Long> getJobExecutionIds() {
            return this.jobExecutionIds;
        }
    }

    static final class JobInstanceAndParameters {
        private final JobInstance jobInstance;
        private final Map<String, JobParameter> identifyingJoParameters;

        JobInstanceAndParameters(JobInstance jobInstance, Map<String, JobParameter> identifyingJoParameters) {
            this.jobInstance = jobInstance;
            this.identifyingJoParameters = identifyingJoParameters;
        }

        JobInstance getJobInstance() {
            return this.jobInstance;
        }

        boolean areIdentifyingJoParametersEqualTo(JobParameters otherJobParameters) {
            Map otherJobParametersMap = otherJobParameters.getParameters();
            for (Map.Entry<String, JobParameter> entry : this.identifyingJoParameters.entrySet()) {
                if (entry.getValue().equals(otherJobParametersMap.get(entry.getKey()))) continue;
                return false;
            }
            for (Map.Entry<String, Object> entry : otherJobParametersMap.entrySet()) {
                JobParameter identifyingJoParameterValue = (JobParameter)entry.getValue();
                if (!identifyingJoParameterValue.isIdentifying() || identifyingJoParameterValue.equals((Object)this.identifyingJoParameters.get(entry.getKey()))) continue;
                return false;
            }
            return true;
        }
    }

    static final class StepExecutionStatistics {
        private Long lastStepExecutionId;
        private Long lastJobExecutionId;
        private int stepExecutionCount;

        StepExecutionStatistics(Long lastStepExecutionId, Long lastJobExecutionId) {
            this.lastStepExecutionId = lastStepExecutionId;
            this.lastJobExecutionId = lastJobExecutionId;
            this.stepExecutionCount = 1;
        }

        Long getLastStepExecutionId() {
            return this.lastStepExecutionId;
        }

        Long getLastJobExecutionId() {
            return this.lastJobExecutionId;
        }

        void setLastExecutionIds(Long lastStepExecutionId, Long lastJobExecutionId) {
            this.lastStepExecutionId = lastStepExecutionId;
            this.lastJobExecutionId = lastJobExecutionId;
        }

        int getStepExecutionCount() {
            return this.stepExecutionCount;
        }

        void incrementStepExecutionCount() {
            ++this.stepExecutionCount;
        }
    }

    static final class StepExecutionKey {
        private final long jobInstanceId;
        private final String stepName;

        StepExecutionKey(long jobInstanceId, String stepName) {
            this.jobInstanceId = jobInstanceId;
            this.stepName = stepName;
        }

        public int hashCode() {
            int result = Long.hashCode(this.jobInstanceId);
            result = 31 * result + this.stepName.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof StepExecutionKey)) {
                return false;
            }
            StepExecutionKey other = (StepExecutionKey)obj;
            return this.jobInstanceId == other.jobInstanceId && Objects.equals(this.stepName, other.stepName);
        }
    }
}

