/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.spring.batch.inmemory;

import com.github.marschall.spring.batch.inmemory.InMemoryJobStorage;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.lang.Nullable;

public final class InMemoryJobRepository
implements JobRepository {
    private static final Log LOGGER = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final InMemoryJobStorage storage;

    public InMemoryJobRepository(InMemoryJobStorage storage) {
        this.storage = storage;
    }

    public boolean isJobInstanceExists(String jobName, JobParameters jobParameters) {
        Objects.requireNonNull(jobName, "jobName");
        Objects.requireNonNull(jobParameters, "jobParameters");
        return this.storage.isJobInstanceExists(jobName, jobParameters);
    }

    public JobInstance createJobInstance(String jobName, JobParameters jobParameters) {
        Objects.requireNonNull(jobName, "jobName");
        Objects.requireNonNull(jobParameters, "jobParameters");
        return this.storage.createJobInstance(jobName, jobParameters);
    }

    public JobExecution createJobExecution(JobInstance jobInstance, JobParameters jobParameters, String jobConfigurationLocation) {
        Objects.requireNonNull(jobInstance, "jobInstance");
        Objects.requireNonNull(jobParameters, "jobParameters");
        return this.storage.createJobExecution(jobInstance, jobParameters, jobConfigurationLocation);
    }

    public JobExecution createJobExecution(String jobName, JobParameters jobParameters) throws JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException {
        Objects.requireNonNull(jobName, "jobName");
        Objects.requireNonNull(jobParameters, "jobParameters");
        return this.storage.createJobExecution(jobName, jobParameters);
    }

    public void update(JobExecution jobExecution) {
        Objects.requireNonNull(jobExecution, "jobExecution");
        Objects.requireNonNull(jobExecution.getJobId(), "jobExecution.getJobId()");
        Objects.requireNonNull(jobExecution.getId(), "jobExecution.getId()");
        this.storage.update(jobExecution);
    }

    private static void validateStepExecution(StepExecution stepExecution) {
        Objects.requireNonNull(stepExecution, "StepExecution cannot be null.");
        Objects.requireNonNull(stepExecution.getStepName(), "StepExecution's step name cannot be null.");
        Objects.requireNonNull(stepExecution.getJobExecutionId(), "StepExecution must belong to persisted JobExecution");
    }

    public void add(StepExecution stepExecution) {
        InMemoryJobRepository.validateStepExecution(stepExecution);
        stepExecution.setLastUpdated(new Date());
        this.storage.addStepExecution(stepExecution);
    }

    public void addAll(Collection<StepExecution> stepExecutions) {
        Date lastUpdated = new Date();
        for (StepExecution stepExecution : stepExecutions) {
            InMemoryJobRepository.validateStepExecution(stepExecution);
            stepExecution.setLastUpdated(lastUpdated);
        }
        this.storage.addStepExecutions(stepExecutions);
    }

    public void update(StepExecution stepExecution) {
        InMemoryJobRepository.validateStepExecution(stepExecution);
        Objects.requireNonNull(stepExecution.getId(), "StepExecution must already be saved (have an id assigned)");
        stepExecution.setLastUpdated(new Date());
        this.storage.updateStepExecution(stepExecution);
        this.checkForInterruption(stepExecution);
    }

    public void updateExecutionContext(StepExecution stepExecution) {
        InMemoryJobRepository.validateStepExecution(stepExecution);
        Objects.requireNonNull(stepExecution.getId(), "StepExecution must already be saved (have an id assigned)");
        this.storage.updateStepExecutionContext(stepExecution);
    }

    public void updateExecutionContext(JobExecution jobExecution) {
        this.storage.updateJobExecutionContext(jobExecution);
    }

    @Nullable
    public StepExecution getLastStepExecution(JobInstance jobInstance, String stepName) {
        return this.storage.getLastStepExecution(jobInstance, stepName);
    }

    public int getStepExecutionCount(JobInstance jobInstance, String stepName) {
        return this.storage.countStepExecutions(jobInstance, stepName);
    }

    @Nullable
    public JobExecution getLastJobExecution(String jobName, JobParameters jobParameters) {
        return this.storage.getLastJobExecution(jobName, jobParameters);
    }

    private void checkForInterruption(StepExecution stepExecution) {
        JobExecution jobExecution = stepExecution.getJobExecution();
        this.storage.synchronizeStatus(jobExecution);
        if (jobExecution.isStopping()) {
            LOGGER.info((Object)("Parent JobExecution " + jobExecution.getId() + " is stopped, so passing message on to StepExecution " + stepExecution.getId()));
            stepExecution.setTerminateOnly();
        }
    }
}

