/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.spring.batch.inmemory;

import com.github.marschall.spring.batch.inmemory.ClearJobRepository;
import com.github.marschall.spring.batch.inmemory.ClearPoint;
import com.github.marschall.spring.batch.inmemory.InMemoryJobStorage;
import java.lang.invoke.MethodHandles;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;

public class ClearTestExecutionListener
extends AbstractTestExecutionListener {
    private static final Log LOGGER = LogFactory.getLog(MethodHandles.lookup().lookupClass());

    public int getOrder() {
        return 10000;
    }

    private static boolean hasClearAnnotation(TestContext testContext, ClearPoint when) {
        Class testClass = testContext.getTestClass();
        ClearJobRepository clearJobRepository = (ClearJobRepository)AnnotationUtils.findAnnotation((Class)testClass, ClearJobRepository.class);
        if (clearJobRepository != null) {
            return clearJobRepository.value() == ClearPoint.AFTER_TEST;
        }
        return false;
    }

    private void clearJobStorage(TestContext testContext) {
        InMemoryJobStorage jobStorage;
        ApplicationContext applicationContext = testContext.getApplicationContext();
        try {
            jobStorage = (InMemoryJobStorage)applicationContext.getBean(InMemoryJobStorage.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            LOGGER.warn((Object)("not bean of type: " + InMemoryJobStorage.class + " found, not clearing"), (Throwable)e);
            return;
        }
        jobStorage.clear();
    }

    public void afterTestExecution(TestContext testContext) {
        if (ClearTestExecutionListener.hasClearAnnotation(testContext, ClearPoint.AFTER_TEST)) {
            this.clearJobStorage(testContext);
        }
    }

    public void afterTestClass(TestContext testContext) {
        if (ClearTestExecutionListener.hasClearAnnotation(testContext, ClearPoint.AFTER_CLASS)) {
            this.clearJobStorage(testContext);
        }
    }
}

