/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.reader;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.kongchen.swagger.docgen.LogAdapter;
import com.github.kongchen.swagger.docgen.reader.AbstractReader;
import com.github.kongchen.swagger.docgen.reader.ClassSwaggerReader;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import io.swagger.converter.ModelConverters;
import io.swagger.jaxrs.PATCH;
import io.swagger.jaxrs.ext.SwaggerExtension;
import io.swagger.jaxrs.ext.SwaggerExtensions;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.SecurityRequirement;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.util.Json;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaxrsReader
extends AbstractReader
implements ClassSwaggerReader {
    Logger LOGGER = LoggerFactory.getLogger(JaxrsReader.class);
    static ObjectMapper m = Json.mapper();

    public JaxrsReader(Swagger swagger, LogAdapter LOG) {
        super(swagger, LOG);
    }

    @Override
    public Swagger read(Set<Class<?>> classes) {
        for (Class<?> cls : classes) {
            this.read(cls);
        }
        return this.swagger;
    }

    public Swagger getSwagger() {
        return this.swagger;
    }

    public Swagger read(Class cls) {
        return this.read(cls, "", null, false, new String[0], new String[0], new HashMap<String, Tag>(), new ArrayList<Parameter>());
    }

    protected Swagger read(Class<?> cls, String parentPath, String parentMethod, boolean readHidden, String[] parentConsumes, String[] parentProduces, Map<String, Tag> parentTags, List<Parameter> parentParameters) {
        Method[] methods;
        if (this.swagger == null) {
            this.swagger = new Swagger();
        }
        Api api = cls.getAnnotation(Api.class);
        HashMap globalScopes = new HashMap();
        Path apiPath = cls.getAnnotation(Path.class);
        if (!this.canReadApi(readHidden, api)) {
            return this.swagger;
        }
        Map<String, Tag> tags = this.updateTagsForApi(parentTags, api);
        List<SecurityRequirement> securities = this.getSecurityRequirements(api);
        for (Method method : methods = cls.getMethods()) {
            ApiOperation apiOperation = method.getAnnotation(ApiOperation.class);
            Path methodPath = method.getAnnotation(Path.class);
            String operationPath = this.getPath(apiPath, methodPath, parentPath);
            if (operationPath == null || apiOperation == null) continue;
            HashMap<String, String> regexMap = new HashMap<String, String>();
            operationPath = this.parseOperationPath(operationPath, regexMap);
            String httpMethod = this.extractOperationMethod(apiOperation, method, SwaggerExtensions.chain());
            Operation operation = this.parseMethod(method);
            this.updateOperationParameters(parentParameters, regexMap, operation);
            this.updateOperationProtocols(apiOperation, operation);
            String[] apiConsumes = new String[]{};
            String[] apiProduces = new String[]{};
            Consumes annotation = cls.getAnnotation(Consumes.class);
            if (annotation != null) {
                apiConsumes = annotation.value();
            }
            if ((annotation = cls.getAnnotation(Produces.class)) != null) {
                apiProduces = ((Produces)annotation).value();
            }
            apiConsumes = this.updateOperationConsumes(parentConsumes, apiConsumes, operation);
            apiProduces = this.updateOperationProduces(parentProduces, apiProduces, operation);
            this.handleSubResource(apiConsumes, httpMethod, apiProduces, tags, method, operationPath, operation);
            httpMethod = httpMethod == null ? parentMethod : httpMethod;
            this.updateTagsForOperation(operation, apiOperation);
            this.updateOperation(apiConsumes, apiProduces, tags, securities, operation);
            this.updatePath(operationPath, httpMethod, operation);
        }
        return this.swagger;
    }

    private void handleSubResource(String[] apiConsumes, String httpMethod, String[] apiProduces, Map<String, Tag> tags, Method method, String operationPath, Operation operation) {
        if (this.isSubResource(method)) {
            Type t = method.getGenericReturnType();
            Class<?> responseClass = method.getReturnType();
            Swagger subSwagger = this.read(responseClass, operationPath, httpMethod, true, apiConsumes, apiProduces, tags, operation.getParameters());
        }
    }

    protected boolean isSubResource(Method method) {
        Type t = method.getGenericReturnType();
        Class<?> responseClass = method.getReturnType();
        return responseClass != null && responseClass.getAnnotation(Api.class) != null;
    }

    String getPath(Path classLevelPath, Path methodLevelPath, String parentPath) {
        String output;
        if (classLevelPath == null && methodLevelPath == null) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        if (parentPath != null && !"".equals(parentPath) && !"/".equals(parentPath)) {
            if (!parentPath.startsWith("/")) {
                parentPath = "/" + parentPath;
            }
            if (parentPath.endsWith("/")) {
                parentPath = parentPath.substring(0, parentPath.length() - 1);
            }
            b.append(parentPath);
        }
        if (classLevelPath != null) {
            b.append(classLevelPath.value());
        }
        if (methodLevelPath != null && !"/".equals(methodLevelPath.value())) {
            String methodPath = methodLevelPath.value();
            if (!methodPath.startsWith("/") && !b.toString().endsWith("/")) {
                b.append("/");
            }
            if (methodPath.endsWith("/")) {
                methodPath = methodPath.substring(0, methodPath.length() - 1);
            }
            b.append(methodPath);
        }
        if (!(output = b.toString()).startsWith("/")) {
            output = "/" + output;
        }
        if (output.endsWith("/") && output.length() > 1) {
            return output.substring(0, output.length() - 1);
        }
        return output;
    }

    public Operation parseMethod(Method method) {
        Operation operation = new Operation();
        ApiOperation apiOperation = method.getAnnotation(ApiOperation.class);
        String operationId = method.getName();
        String responseContainer = null;
        Class responseClass = null;
        Map<Object, Object> defaultResponseHeaders = new HashMap();
        if (apiOperation != null) {
            if (apiOperation.hidden()) {
                return null;
            }
            if (!"".equals(apiOperation.nickname())) {
                operationId = apiOperation.nickname();
            }
            defaultResponseHeaders = this.parseResponseHeaders(apiOperation.responseHeaders());
            operation.summary(apiOperation.value()).description(apiOperation.notes());
            if (apiOperation.response() != null && !Void.class.equals((Object)apiOperation.response())) {
                responseClass = apiOperation.response();
            }
            if (!"".equals(apiOperation.responseContainer())) {
                responseContainer = apiOperation.responseContainer();
            }
            if (apiOperation.authorizations() != null) {
                ArrayList<SecurityRequirement> securities = new ArrayList<SecurityRequirement>();
                for (Authorization auth : apiOperation.authorizations()) {
                    AuthorizationScope[] scopes;
                    if (auth.value() == null || "".equals(auth.value())) continue;
                    SecurityRequirement security = new SecurityRequirement();
                    security.setName(auth.value());
                    for (AuthorizationScope scope : scopes = auth.scopes()) {
                        if (scope.scope() == null || "".equals(scope.scope())) continue;
                        security.addScope(scope.scope());
                    }
                    securities.add(security);
                }
                if (securities.size() > 0) {
                    for (SecurityRequirement sec : securities) {
                        operation.security(sec);
                    }
                }
            }
        }
        if (responseClass == null) {
            this.LOGGER.debug("picking up response class from method " + method);
            Type t = method.getGenericReturnType();
            responseClass = method.getReturnType();
            if (!responseClass.equals(Void.class) && !"void".equals(responseClass.toString()) && responseClass.getAnnotation(Api.class) == null) {
                this.LOGGER.debug("reading model " + responseClass);
                Map models = ModelConverters.getInstance().readAll(t);
            }
        }
        if (responseClass != null && !responseClass.equals(Void.class) && !responseClass.equals(Response.class) && responseClass.getAnnotation(Api.class) == null) {
            if (this.isPrimitive(responseClass)) {
                Object responseProperty = null;
                Property property = ModelConverters.getInstance().readAsProperty(responseClass);
                if (property != null) {
                    responseProperty = "list".equalsIgnoreCase(responseContainer) ? new ArrayProperty(property) : ("map".equalsIgnoreCase(responseContainer) ? new MapProperty(property) : property);
                    operation.response(200, new io.swagger.models.Response().description("successful operation").schema((Property)responseProperty).headers(defaultResponseHeaders));
                }
            } else if (!responseClass.equals(Void.class) && !"void".equals(responseClass.toString())) {
                Map models = ModelConverters.getInstance().read((Type)responseClass);
                if (models.size() == 0) {
                    Property p = ModelConverters.getInstance().readAsProperty((Type)responseClass);
                    operation.response(200, new io.swagger.models.Response().description("successful operation").schema(p).headers(defaultResponseHeaders));
                }
                for (String key : models.keySet()) {
                    Object responseProperty = null;
                    responseProperty = "list".equalsIgnoreCase(responseContainer) ? new ArrayProperty((Property)new RefProperty().asDefault(key)) : ("map".equalsIgnoreCase(responseContainer) ? new MapProperty((Property)new RefProperty().asDefault(key)) : new RefProperty().asDefault(key));
                    operation.response(200, new io.swagger.models.Response().description("successful operation").schema((Property)responseProperty).headers(defaultResponseHeaders));
                    this.swagger.model(key, (Model)models.get(key));
                }
                models = ModelConverters.getInstance().readAll((Type)responseClass);
                for (String key : models.keySet()) {
                    this.swagger.model(key, (Model)models.get(key));
                }
            }
        }
        operation.operationId(operationId);
        Object annotation = method.getAnnotation(Consumes.class);
        if (annotation != null) {
            String[] apiConsumes;
            for (String mediaType : apiConsumes = annotation.value()) {
                operation.consumes(mediaType);
            }
        }
        if ((annotation = method.getAnnotation(Produces.class)) != null) {
            String[] apiProduces;
            for (String mediaType : apiProduces = ((Produces)annotation).value()) {
                operation.produces(mediaType);
            }
        }
        ArrayList apiResponses = new ArrayList();
        ApiResponses responseAnnotation = method.getAnnotation(ApiResponses.class);
        if (responseAnnotation != null) {
            this.updateApiResponse(operation, responseAnnotation);
        }
        boolean isDeprecated = false;
        annotation = method.getAnnotation(Deprecated.class);
        if (annotation != null) {
            isDeprecated = true;
        }
        boolean hidden = false;
        if (apiOperation != null) {
            hidden = apiOperation.hidden();
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Type type = genericParameterTypes[i];
            List<Annotation> annotations = Arrays.asList(paramAnnotations[i]);
            List<Parameter> parameters = this.getParameters(type, annotations);
            for (Parameter parameter : parameters) {
                operation.parameter(parameter);
            }
        }
        if (operation.getResponses() == null) {
            operation.defaultResponse(new io.swagger.models.Response().description("successful operation"));
        }
        this.readImplicitParameters(method, operation);
        return operation;
    }

    public String extractOperationMethod(ApiOperation apiOperation, Method method, Iterator<SwaggerExtension> chain) {
        if (apiOperation.httpMethod() != null && !"".equals(apiOperation.httpMethod())) {
            return apiOperation.httpMethod().toLowerCase();
        }
        if (method.getAnnotation(GET.class) != null) {
            return "get";
        }
        if (method.getAnnotation(PUT.class) != null) {
            return "put";
        }
        if (method.getAnnotation(POST.class) != null) {
            return "post";
        }
        if (method.getAnnotation(DELETE.class) != null) {
            return "delete";
        }
        if (method.getAnnotation(OPTIONS.class) != null) {
            return "options";
        }
        if (method.getAnnotation(HEAD.class) != null) {
            return "head";
        }
        if (method.getAnnotation(PATCH.class) != null) {
            return "patch";
        }
        if (method.getAnnotation(HttpMethod.class) != null) {
            HttpMethod httpMethod = method.getAnnotation(HttpMethod.class);
            return httpMethod.value().toLowerCase();
        }
        if (chain.hasNext()) {
            return chain.next().extractOperationMethod(apiOperation, method, chain);
        }
        return null;
    }
}

