/*
 * Decompiled with CFR 0.152.
 */
package com.github.kischang.fastdfs.pool;

import com.github.kischang.fastdfs.FastDFSTemplateFactory;
import com.github.kischang.fastdfs.pool.ConnectionFactory;
import com.github.kischang.fastdfs.pool.PoolConfig;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.csource.fastdfs.StorageClient;

public class ConnectionPoolFactory {
    private GenericObjectPool<StorageClient> pool;

    public ConnectionPoolFactory(FastDFSTemplateFactory fastDFSTemplateFactory) {
        GenericObjectPool.Config config = this.toConfig(fastDFSTemplateFactory.getPoolConfig());
        this.pool = new GenericObjectPool((PoolableObjectFactory)new ConnectionFactory(fastDFSTemplateFactory), config);
    }

    public StorageClient getClient() throws Exception {
        return (StorageClient)this.pool.borrowObject();
    }

    public void releaseConnection(StorageClient client) {
        try {
            this.pool.returnObject((Object)client);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private GenericObjectPool.Config toConfig(PoolConfig poolConfig) {
        GenericObjectPool.Config config = new GenericObjectPool.Config();
        config.maxIdle = poolConfig.maxIdle;
        config.minIdle = poolConfig.minIdle;
        config.maxActive = poolConfig.maxActive;
        config.maxWait = poolConfig.maxWait;
        config.whenExhaustedAction = poolConfig.whenExhaustedAction;
        config.testOnBorrow = poolConfig.testOnBorrow;
        config.testOnReturn = poolConfig.testOnReturn;
        config.testWhileIdle = poolConfig.testWhileIdle;
        config.timeBetweenEvictionRunsMillis = poolConfig.timeBetweenEvictionRunsMillis;
        config.numTestsPerEvictionRun = poolConfig.numTestsPerEvictionRun;
        config.minEvictableIdleTimeMillis = poolConfig.minEvictableIdleTimeMillis;
        config.softMinEvictableIdleTimeMillis = poolConfig.softMinEvictableIdleTimeMillis;
        config.lifo = poolConfig.lifo;
        return config;
    }
}

