/*
 * Decompiled with CFR 0.152.
 */
package com.github.kischang.fastdfs.pool;

import com.github.kischang.fastdfs.FastDFSTemplateFactory;
import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.csource.fastdfs.StorageClient;
import org.csource.fastdfs.TrackerClient;
import org.csource.fastdfs.TrackerServer;

class ConnectionFactory
extends BasePoolableObjectFactory<StorageClient> {
    private FastDFSTemplateFactory factory;

    public ConnectionFactory(FastDFSTemplateFactory templateFactory) {
        this.factory = templateFactory;
    }

    public StorageClient makeObject() throws Exception {
        TrackerClient trackerClient = new TrackerClient(this.factory.getG_tracker_group());
        TrackerServer trackerServer = trackerClient.getConnection();
        return new StorageClient(trackerServer, null);
    }

    public void destroyObject(StorageClient obj) throws Exception {
        this.close(obj.getTrackerServer());
    }

    public boolean validateObject(StorageClient obj) {
        try {
            Socket socket = obj.getTrackerServer().getSocket();
            if (!socket.isConnected()) {
                return false;
            }
            return !socket.isClosed();
        }
        catch (IOException e) {
            return false;
        }
    }

    private void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

