/*
 * Decompiled with CFR 0.152.
 */
package com.github.jmkgreen.morphia.validation;

import com.github.jmkgreen.morphia.utils.Assert;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerboseJSR303ConstraintViolationException
extends ConstraintViolationException {
    public VerboseJSR303ConstraintViolationException(Set<ConstraintViolation<?>> vio) {
        super(VerboseJSR303ConstraintViolationException.createVerboseMessage(vio), vio);
        Assert.parameterNotNull(vio, (String)"vio");
    }

    private static String createVerboseMessage(Set<ConstraintViolation<?>> vio) {
        StringBuffer sb = new StringBuffer(128);
        sb.append("The following constraints have been violated:\n");
        for (ConstraintViolation<?> c : vio) {
            sb.append(c.getRootBeanClass().getSimpleName());
            sb.append(".");
            sb.append(c.getPropertyPath());
            sb.append(": ");
            sb.append(c.getMessage());
            sb.append(" ('");
            sb.append(c.getInvalidValue());
            sb.append("')\n");
        }
        return sb.toString();
    }
}

