/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlgrock.javascriptframework.closurecompiler;

import com.github.jlgrock.javascriptframework.closurecompiler.CalcDeps;
import com.github.jlgrock.javascriptframework.closurecompiler.ErrorLevel;
import com.github.jlgrock.javascriptframework.closurecompiler.InclusionStrategy;
import com.github.jlgrock.javascriptframework.closurecompiler.StrictLevel;
import com.github.jlgrock.javascriptframework.mavenutils.logging.Log4jOutputStream;
import com.github.jlgrock.javascriptframework.mavenutils.logging.MojoLogAppender;
import com.github.jlgrock.javascriptframework.mavenutils.mavenobjects.JsarRelativeLocations;
import com.github.jlgrock.javascriptframework.mavenutils.pathing.FileListBuilder;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.google.javascript.jscomp.CommandLineRunner;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSSourceFile;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.WarningLevel;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class JsClosureCompileMojo
extends AbstractMojo {
    private static final Logger LOGGER = Logger.getLogger(JsClosureCompileMojo.class);
    private File closureLibraryLocation;
    private String compiledFilename;
    private String compileLevel;
    private String errorLevel;
    private File frameworkTargetDirectory;
    private String generatedAssertJS;
    private String generatedAssertRequiresJS;
    private String generatedDebugJS;
    private String generatedDebugRequiresJS;
    private boolean generateExports;
    private String inclusionStrategy;
    private File testSourceDirectory;
    private String outputWrapper = "";
    private static final String OUTPUT_WRAPPER_MARKER = "%output%";

    private static List<JSSourceFile> convertToJSSourceFiles(Collection<File> jsFiles) {
        ArrayList<JSSourceFile> jsSourceFiles = new ArrayList<JSSourceFile>();
        for (File f : jsFiles) {
            jsSourceFiles.add(JSSourceFile.fromFile((File)f));
        }
        return jsSourceFiles;
    }

    private static List<File> createDepsAndRequiresJS(File baseLocation, Collection<File> src, Collection<File> interns, File depsFile, File requiresFile) throws MojoExecutionException, IOException {
        LOGGER.debug((Object)("base location: " + baseLocation));
        LOGGER.debug((Object)("src files: " + src));
        LOGGER.debug((Object)("intern files: " + interns));
        LOGGER.debug((Object)("deps file location: " + depsFile));
        return CalcDeps.executeCalcDeps(baseLocation, src, interns, depsFile, requiresFile);
    }

    private static File getBaseLocation(File closureLibraryLocation) throws MojoExecutionException {
        File baseLocation = new File(closureLibraryLocation.getAbsoluteFile() + File.separator + "closure" + File.separator + "goog" + File.separator + "base.js");
        if (!baseLocation.exists()) {
            throw new MojoExecutionException("Could not locate \"base.js\" at location \"" + baseLocation.getParentFile().getAbsolutePath() + "\"");
        }
        return baseLocation;
    }

    private static void listErrors(Result result) {
        for (JSError warning : result.warnings) {
            LOGGER.warn((Object)("[Goog.WARN]: " + warning.toString()));
        }
        for (JSError error : result.errors) {
            LOGGER.error((Object)("[Goog.ERROR]: " + error.toString()));
        }
    }

    private static Set<File> listFiles(File directory) {
        return FileListBuilder.buildFilteredList((File)directory, (String)"js");
    }

    private List<JSSourceFile> calculateExternFiles() throws IOException {
        Set<File> externSourceFiles = JsClosureCompileMojo.listFiles(JsarRelativeLocations.getExternsLocation((File)this.frameworkTargetDirectory));
        List<JSSourceFile> externalJSSourceFiles = JsClosureCompileMojo.convertToJSSourceFiles(externSourceFiles);
        externalJSSourceFiles.addAll(CommandLineRunner.getDefaultExterns());
        LOGGER.debug((Object)("number of external files:" + externalJSSourceFiles.size()));
        return externalJSSourceFiles;
    }

    private Collection<File> calculateInternalFiles(File internsLocation, Collection<File> source) throws MojoExecutionException, IOException {
        Set<File> internalSourceFiles = JsClosureCompileMojo.listFiles(internsLocation);
        LOGGER.debug((Object)("number of internal dependency files:" + internalSourceFiles.size()));
        Set<File> closureLibFiles = JsClosureCompileMojo.listFiles(this.closureLibraryLocation);
        LOGGER.debug((Object)("number of google lib files:" + closureLibFiles.size()));
        HashSet<File> combinedInternal = new HashSet<File>();
        combinedInternal.addAll(source);
        combinedInternal.addAll(internalSourceFiles);
        combinedInternal.addAll(closureLibFiles);
        return combinedInternal;
    }

    private Set<File> calculateSourceFiles(File sourceDir, File internsLocation) {
        InclusionStrategy strategy = InclusionStrategy.getByType(this.inclusionStrategy);
        if (strategy == null) {
            strategy = InclusionStrategy.WHEN_IN_SRCS;
        }
        LOGGER.info((Object)("Calculating source files using Inclusion strategy: " + (Object)((Object)strategy)));
        HashSet<File> listSourceFiles = new HashSet<File>();
        if (strategy.equals((Object)InclusionStrategy.WHEN_IN_SRCS)) {
            listSourceFiles.addAll(JsClosureCompileMojo.listFiles(sourceDir));
        } else {
            listSourceFiles.addAll(JsClosureCompileMojo.listFiles(sourceDir));
            listSourceFiles.addAll(JsClosureCompileMojo.listFiles(internsLocation));
        }
        LOGGER.debug((Object)("number of source files:" + listSourceFiles.size()));
        return listSourceFiles;
    }

    private boolean compile(Collection<JSSourceFile> allSources, Collection<JSSourceFile> externs) throws MojoExecutionException, MojoFailureException, IOException {
        CompilationLevel compilationLevel = null;
        try {
            compilationLevel = CompilationLevel.valueOf((String)this.compileLevel);
            LOGGER.info((Object)("Compiler set to optimization level \"" + this.compileLevel + "\"."));
        }
        catch (IllegalArgumentException e) {
            LOGGER.error((Object)"Compilation level invalid.  Aborting.");
            throw new MojoExecutionException("Compilation level invalid.  Aborting.");
        }
        CompilerOptions compilerOptions = new CompilerOptions();
        if (ErrorLevel.getCompileLevelByName(this.errorLevel).equals((Object)ErrorLevel.WARNING)) {
            WarningLevel wLevel = WarningLevel.VERBOSE;
            wLevel.setOptionsForWarningLevel(compilerOptions);
        } else if (ErrorLevel.getCompileLevelByName(this.errorLevel).equals((Object)ErrorLevel.STRICT)) {
            StrictLevel sLevel = StrictLevel.VERBOSE;
            sLevel.setOptionsForWarningLevel(compilerOptions);
        }
        compilationLevel.setOptionsForCompilationLevel(compilerOptions);
        compilerOptions.setGenerateExports(this.generateExports);
        PrintStream ps = new PrintStream((OutputStream)new Log4jOutputStream(LOGGER, Level.DEBUG), true);
        Compiler compiler = new Compiler(ps);
        for (JSSourceFile jsf : allSources) {
            LOGGER.debug((Object)("source files: " + jsf.getOriginalPath()));
        }
        Result result = null;
        try {
            LOGGER.debug((Object)("externJSSourceFiles: " + externs));
            LOGGER.debug((Object)("allSources: " + allSources));
            result = compiler.compile(externs.toArray(new JSSourceFile[externs.size()]), allSources.toArray(new JSSourceFile[allSources.size()]), compilerOptions);
        }
        catch (Exception e) {
            LOGGER.error((Object)"There was a problem with the compile.  Please review input.");
            e.printStackTrace();
            throw new MojoExecutionException(e.getMessage(), e);
        }
        JsClosureCompileMojo.listErrors(result);
        if (!result.success) {
            return false;
        }
        File compiledFile = new File(JsarRelativeLocations.getCompileLocation((File)this.frameworkTargetDirectory), this.compiledFilename);
        Files.createParentDirs((File)compiledFile);
        Files.touch((File)compiledFile);
        JsClosureCompileMojo.writeOutput(compiledFile, compiler, this.outputWrapper, OUTPUT_WRAPPER_MARKER);
        return true;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        MojoLogAppender.beginLogging((AbstractMojo)this);
        try {
            LOGGER.info((Object)("Compiling source files and internal dependencies to location \"" + JsarRelativeLocations.getCompileLocation((File)this.frameworkTargetDirectory).getAbsolutePath() + "\"."));
            List<JSSourceFile> externs = this.calculateExternFiles();
            File baseLocation = JsClosureCompileMojo.getBaseLocation(this.closureLibraryLocation);
            Set<File> assertSourceFiles = this.calculateSourceFiles(JsarRelativeLocations.getAssertionSourceLocation((File)this.frameworkTargetDirectory), JsarRelativeLocations.getInternsAssertLocation((File)this.frameworkTargetDirectory));
            File assertFile = this.getGeneratedAssertJS();
            File assertRequiresFile = this.getGeneratedAssertRequiresJS();
            Collection<File> assertInternFiles = this.calculateInternalFiles(JsarRelativeLocations.getInternsAssertLocation((File)this.frameworkTargetDirectory), assertSourceFiles);
            JsClosureCompileMojo.createDepsAndRequiresJS(baseLocation, assertSourceFiles, assertInternFiles, assertFile, assertRequiresFile);
            File debugFile = this.getGeneratedDebugJS();
            File debugRequiresFile = this.getGeneratedDebugRequiresJS();
            Set<File> sourceFiles = this.calculateSourceFiles(JsarRelativeLocations.getDebugSourceLocation((File)this.frameworkTargetDirectory), JsarRelativeLocations.getInternsDebugLocation((File)this.frameworkTargetDirectory));
            Collection<File> debugInternFiles = this.calculateInternalFiles(JsarRelativeLocations.getInternsDebugLocation((File)this.frameworkTargetDirectory), sourceFiles);
            List<File> debugDepsFiles = JsClosureCompileMojo.createDepsAndRequiresJS(baseLocation, sourceFiles, debugInternFiles, debugFile, debugRequiresFile);
            File testDepsFile = this.getGeneratedTestJS();
            HashSet<File> srcAndTest = new HashSet<File>();
            srcAndTest.addAll(assertSourceFiles);
            srcAndTest.addAll(FileListBuilder.buildFilteredList((File)this.testSourceDirectory, (String)"js"));
            JsClosureCompileMojo.createDepsAndRequiresJS(baseLocation, srcAndTest, assertInternFiles, testDepsFile, null);
            ArrayList<File> debugFiles = new ArrayList<File>();
            debugFiles.add(JsClosureCompileMojo.getBaseLocation(this.closureLibraryLocation));
            debugFiles.add(debugFile);
            debugFiles.addAll(debugDepsFiles);
            boolean result = this.compile(JsClosureCompileMojo.convertToJSSourceFiles(debugFiles), externs);
            if (!result) {
                String message = "Google Closure Compilation failure.  Please review errors to continue.";
                LOGGER.error((Object)message);
                throw new MojoFailureException(message);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            e.printStackTrace(new PrintStream((OutputStream)new Log4jOutputStream(LOGGER, Level.DEBUG), true));
            throw new MojoExecutionException("Unable to closure compile files: " + e.getMessage());
        }
        finally {
            MojoLogAppender.endLogging();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeOutput(File outFile, Compiler compiler, String wrapper, String codePlaceholder) throws IOException {
        FileWriter out = new FileWriter(outFile);
        String code = compiler.toSource();
        boolean threw = true;
        try {
            int pos = wrapper.indexOf(codePlaceholder);
            LOGGER.debug((Object)("wrapper = " + wrapper));
            if (pos != -1) {
                String prefix = "";
                if (pos > 0) {
                    prefix = wrapper.substring(0, pos);
                    LOGGER.debug((Object)("prefix" + prefix));
                    out.append(prefix);
                }
                out.append(code);
                int suffixStart = pos + codePlaceholder.length();
                if (suffixStart != wrapper.length()) {
                    LOGGER.debug((Object)("suffix" + wrapper.substring(suffixStart)));
                    out.append(wrapper.substring(suffixStart));
                }
                out.append('\n');
                if (compiler != null && compiler.getSourceMap() != null) {
                    compiler.getSourceMap().setWrapperPrefix(prefix);
                }
            } else {
                out.append(code);
                out.append('\n');
            }
            threw = false;
        }
        finally {
            Closeables.close((Closeable)out, (boolean)threw);
        }
    }

    private File getGeneratedAssertJS() {
        return new File(JsarRelativeLocations.getAssertDepsLocation((File)this.frameworkTargetDirectory), this.generatedAssertJS);
    }

    private File getGeneratedDebugJS() {
        return new File(JsarRelativeLocations.getDebugDepsLocation((File)this.frameworkTargetDirectory), this.generatedDebugJS);
    }

    private File getGeneratedTestJS() {
        return new File(JsarRelativeLocations.getTestDepsLocation((File)this.frameworkTargetDirectory), this.generatedAssertJS);
    }

    private File getGeneratedAssertRequiresJS() {
        return new File(JsarRelativeLocations.getAssertRequiresLocation((File)this.frameworkTargetDirectory), this.generatedAssertRequiresJS);
    }

    private File getGeneratedDebugRequiresJS() {
        return new File(JsarRelativeLocations.getDebugRequiresLocation((File)this.frameworkTargetDirectory), this.generatedDebugRequiresJS);
    }
}

