/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlgrock.javascriptframework.closurecompiler;

import com.github.jlgrock.javascriptframework.mavenutils.pathing.RelativePath;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class DependencyInfo
implements Comparable<DependencyInfo> {
    private File file;
    private Set<String> provides;
    private Set<String> requires;
    private Set<String> namespaces;

    public DependencyInfo(File parsedFile) {
        this.file = parsedFile;
        this.provides = new HashSet<String>();
        this.requires = new HashSet<String>();
    }

    public final String toDepsString(File basePath) throws IOException {
        String filePath = "";
        if (basePath == null) {
            filePath = this.getFile().getCanonicalPath();
        } else {
            try {
                filePath = RelativePath.getRelPathFromBase((File)basePath, (File)this.getFile());
            }
            catch (IOException e) {
                filePath = "";
            }
        }
        return "goog.addDependency('" + filePath + "', " + this.getProvidesString() + ", " + this.getRequiresString() + ");";
    }

    public final String toRequiresString(File basePath) throws IOException {
        StringBuilder providesString = new StringBuilder();
        for (String provide : this.getProvides()) {
            providesString.append("goog.require(\"");
            providesString.append(provide);
            providesString.append("\");\n");
        }
        return providesString.toString();
    }

    public final void addToProvides(String namespace) {
        this.provides.add(namespace);
    }

    public final void addToRequires(String namespace) {
        this.requires.add(namespace);
    }

    public final File getFile() {
        return this.file;
    }

    public final String getFilename() {
        return this.file.getName();
    }

    public final Collection<String> getProvides() {
        return this.provides;
    }

    public final String getProvidesString() {
        StringBuilder providesString = new StringBuilder();
        int i = 0;
        providesString.append("[");
        for (String provide : this.getProvides()) {
            if (i > 0) {
                providesString.append(", ");
            }
            providesString.append("'");
            providesString.append(provide);
            providesString.append("'");
            ++i;
        }
        providesString.append("]");
        return providesString.toString();
    }

    public final Collection<String> getRequires() {
        return this.requires;
    }

    public final String getRequiresString() {
        StringBuilder requiresString = new StringBuilder();
        int i = 0;
        requiresString.append("[");
        for (String require : this.getRequires()) {
            if (i > 0) {
                requiresString.append(", ");
            }
            requiresString.append("'");
            requiresString.append(require);
            requiresString.append("'");
            ++i;
        }
        requiresString.append("]");
        return requiresString.toString();
    }

    @Override
    public final int compareTo(DependencyInfo o) {
        int returnVal = 0;
        for (String require : this.getRequires()) {
            if (!o.getProvides().contains(require)) continue;
            returnVal = -1;
        }
        for (String provide : this.getProvides()) {
            if (!o.getRequires().contains(provide)) continue;
            returnVal = 1;
        }
        return returnVal;
    }

    public final void addToNamespaces(String namespace) {
        this.namespaces.add(namespace);
    }

    public final String getNamespaceString() {
        StringBuilder namepaceString = new StringBuilder();
        int i = 0;
        namepaceString.append("[");
        for (String namespace : this.getNamespaces()) {
            if (i > 0) {
                namepaceString.append(", ");
            }
            namepaceString.append("'");
            namepaceString.append(namespace);
            namepaceString.append("'");
            ++i;
        }
        namepaceString.append("]");
        return namepaceString.toString();
    }

    public final Set<String> getNamespaces() {
        return this.namespaces;
    }
}

