/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlgrock.javascriptframework.closurecompiler;

import com.github.jlgrock.javascriptframework.closurecompiler.AnnotationFileReader;
import com.github.jlgrock.javascriptframework.closurecompiler.DependencyInfo;
import com.github.jlgrock.javascriptframework.mavenutils.io.DirectoryIO;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public final class CalcDeps {
    private static final Logger LOGGER = Logger.getLogger(CalcDeps.class);

    private CalcDeps() {
    }

    private static HashMap<File, DependencyInfo> buildDependenciesFromFiles(File googleBaseJS, Collection<File> files) throws IOException {
        HashMap<File, DependencyInfo> result = new HashMap<File, DependencyInfo>();
        HashSet<File> searchedAlready = new HashSet<File>();
        for (File file : files) {
            if (searchedAlready.contains(file) || file.equals(googleBaseJS)) continue;
            DependencyInfo dep = AnnotationFileReader.parseForDependencyInfo(file);
            result.put(file, dep);
            searchedAlready.add(file);
        }
        return result;
    }

    private static List<DependencyInfo> calculateDependencies(File baseJs, Collection<File> inputs, Collection<File> paths) throws IOException {
        HashSet<File> temp = new HashSet<File>();
        temp.addAll(inputs);
        HashMap<File, DependencyInfo> inputHash = CalcDeps.buildDependenciesFromFiles(baseJs, inputs);
        HashMap<File, DependencyInfo> searchHash = CalcDeps.buildDependenciesFromFiles(baseJs, paths);
        LOGGER.info((Object)"Dependencies Calculated.");
        List<DependencyInfo> sortedDeps = CalcDeps.slowSort(inputHash.values(), searchHash.values());
        LOGGER.info((Object)"Dependencies Sorted.");
        return sortedDeps;
    }

    private static boolean outputDeps(File googleBaseFile, Collection<DependencyInfo> sortedDeps, File outputFile) throws IOException {
        DirectoryIO.createDir((File)outputFile.getParentFile());
        FileWriter fw = new FileWriter(outputFile);
        BufferedWriter buff = new BufferedWriter(fw);
        buff.append("\n// This file was autogenerated by CalcDeps.java\n");
        for (DependencyInfo fileDep : sortedDeps) {
            if (fileDep == null) continue;
            buff.write(fileDep.toDepsString(googleBaseFile));
            buff.write("\n");
            buff.flush();
        }
        LOGGER.info((Object)"Deps file written.");
        return true;
    }

    private static boolean outputRequires(File googleBaseFile, Collection<DependencyInfo> sortedDeps, File outputFile) throws IOException {
        DirectoryIO.createDir((File)outputFile.getParentFile());
        FileWriter fw = new FileWriter(outputFile);
        BufferedWriter buff = new BufferedWriter(fw);
        buff.append("\n// This file was autogenerated by CalcDeps.java\n");
        for (DependencyInfo fileDep : sortedDeps) {
            if (fileDep == null) continue;
            buff.write(fileDep.toRequiresString(googleBaseFile));
            buff.flush();
        }
        LOGGER.info((Object)"Deps file written.");
        return true;
    }

    private static List<DependencyInfo> slowSort(Collection<DependencyInfo> inputs, Collection<DependencyInfo> deps) {
        HashMap<String, DependencyInfo> searchSet = CalcDeps.buildSearchList(deps);
        HashSet<File> seenList = new HashSet<File>();
        ArrayList<DependencyInfo> resultList = new ArrayList<DependencyInfo>();
        for (DependencyInfo input : inputs) {
            if (seenList.contains(input.getFile())) continue;
            seenList.add(input.getFile());
            for (String require : input.getRequires()) {
                CalcDeps.orderDependenciesForNamespace(input.getFile(), require, searchSet, seenList, resultList);
            }
            resultList.add(input);
        }
        return resultList;
    }

    private static void orderDependenciesForNamespace(File inputFile, String requireNamespace, HashMap<String, DependencyInfo> searchSet, HashSet<File> seenList, ArrayList<DependencyInfo> resultList) {
        DependencyInfo dep;
        if (!searchSet.containsKey(requireNamespace)) {
            LOGGER.error((Object)("Problem with require in file '" + inputFile.getName() + "'.  Can't find a goog.require for '" + requireNamespace + "'"));
        }
        if (!seenList.contains((dep = searchSet.get(requireNamespace)).getFile())) {
            seenList.add(dep.getFile());
            for (String subRequire : dep.getRequires()) {
                CalcDeps.orderDependenciesForNamespace(dep.getFile(), subRequire, searchSet, seenList, resultList);
            }
            resultList.add(dep);
        }
    }

    private static HashMap<String, DependencyInfo> buildSearchList(Collection<DependencyInfo> deps) {
        HashMap<String, DependencyInfo> returnVal = new HashMap<String, DependencyInfo>();
        for (DependencyInfo dep : deps) {
            for (String provide : dep.getProvides()) {
                returnVal.put(provide, dep);
            }
        }
        return returnVal;
    }

    private static List<File> pullFilesFromDeps(List<DependencyInfo> sortedDeps) {
        ArrayList<File> returnVal = new ArrayList<File>();
        for (DependencyInfo dep : sortedDeps) {
            returnVal.add(dep.getFile());
        }
        return returnVal;
    }

    public static List<File> executeCalcDeps(File googleBaseFile, Collection<File> inputs, Collection<File> paths, File depsFile, File requiresFile) throws IOException {
        LOGGER.debug((Object)"Finding Closure dependencies...");
        List<DependencyInfo> sortedDeps = CalcDeps.calculateDependencies(googleBaseFile, inputs, paths);
        LOGGER.debug((Object)"Outputting Closure dependency file...");
        CalcDeps.outputDeps(googleBaseFile, sortedDeps, depsFile);
        if (requiresFile != null) {
            LOGGER.debug((Object)"Outputting Closure dependency requires file...");
            CalcDeps.outputRequires(googleBaseFile, sortedDeps, requiresFile);
        }
        LOGGER.debug((Object)"Closure dependencies created");
        return CalcDeps.pullFilesFromDeps(sortedDeps);
    }
}

