/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlgrock.javascriptframework.closurecompiler;

import com.github.jlgrock.javascriptframework.closurecompiler.DependencyInfo;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public final class AnnotationFileReader {
    private static final Logger LOGGER = Logger.getLogger(AnnotationFileReader.class);
    public static final Pattern REQ_REGEX = Pattern.compile("goog\\.require\\s*\\(\\s*[\\'\\\"]([^\\)]+)[\\'\\\"]\\s*\\)");
    public static final Pattern PROV_REGEX = Pattern.compile("goog\\.provide\\s*\\(\\s*[\\'\\\"]([^\\)]+)[\\'\\\"]\\s*\\)");
    public static final Pattern NS_REGEX = Pattern.compile("^ns:((\\w+\\.)*(\\w+))$");

    private AnnotationFileReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DependencyInfo parseForDependencyInfo(File file) throws IOException {
        DependencyInfo dep = new DependencyInfo(file);
        FileInputStream filestream = null;
        try {
            String strLine;
            if (!file.exists() || !file.isFile()) {
                throw new IOException("the File at location " + file.getCanonicalPath() + " does not exist");
            }
            filestream = new FileInputStream(file);
            DataInputStream in = new DataInputStream(filestream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((strLine = br.readLine()) != null) {
                Matcher m = PROV_REGEX.matcher(strLine);
                if (m.lookingAt()) {
                    for (int i = 0; i < m.groupCount(); ++i) {
                        String s = m.group(1);
                        dep.addToProvides(s);
                    }
                }
                if ((m = REQ_REGEX.matcher(strLine)).lookingAt()) {
                    String s = m.group(1);
                    dep.addToRequires(s);
                }
                if (!(m = NS_REGEX.matcher(strLine)).lookingAt()) continue;
                String s = m.group(1);
                dep.addToNamespaces(s);
            }
        }
        finally {
            if (filestream != null) {
                filestream.close();
            }
        }
        return dep;
    }
}

