/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.cpdetector.io;

import info.monitorenter.cpdetector.io.IClassFileFilter;
import info.monitorenter.util.Entry;
import info.monitorenter.util.FileUtil;
import info.monitorenter.util.StringUtil;
import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ClassFileFilterIsA
implements IClassFileFilter,
FileFilter {
    protected Set superclasses = new TreeSet();
    protected File[] classpaths;

    public ClassFileFilterIsA() {
        this.scanClassPath();
    }

    private void scanClassPath() {
        URLClassLoader urlcl = (URLClassLoader)this.getClass().getClassLoader();
        URL[] urls = urlcl.getURLs();
        LinkedList<File> collect = new LinkedList<File>();
        for (int i = 0; i < urls.length; ++i) {
            File f = this.urlToFile(urls[i]);
            if (f == null) continue;
            collect.add(f);
        }
        this.classpaths = collect.toArray(new File[collect.size()]);
    }

    private File urlToFile(URL url) {
        File ret = null;
        if (url.getProtocol().equalsIgnoreCase("file")) {
            ret = new File(url.getFile());
        }
        return ret;
    }

    public synchronized boolean addSuperClass(Class c) {
        boolean ret = false;
        if ((c.getModifiers() & 0x10) == 0) {
            ret = this.superclasses.add(c);
        }
        return ret;
    }

    public boolean accept(Class c) {
        boolean ret = false;
        Iterator it = this.superclasses.iterator();
        while (it.hasNext() && !ret) {
            ret = ((Class)it.next()).isAssignableFrom(c);
        }
        return ret;
    }

    public boolean accept(File pathname) {
        boolean ret = false;
        if (pathname.isDirectory()) {
            ret = true;
        } else {
            String ext = FileUtil.cutExtension(pathname.getName()).getValue().toString();
            if (ext.equals("jar")) {
                ret = true;
            } else if (ext.equals("class")) {
                Class cl = this.forFile(pathname);
                if (cl != null) {
                    ret = this.accept(cl);
                }
            } else {
                ret = false;
            }
        }
        return ret;
    }

    private Class forFile(File f) {
        Class<?> ret = null;
        Map.Entry<String, String> searchpath = new Entry<String, String>("", "");
        String filename = f.getAbsolutePath();
        for (int i = 0; i < this.classpaths.length && searchpath.getKey().equals(""); ++i) {
            searchpath = StringUtil.prefixIntersection(this.classpaths[i].getAbsolutePath(), filename);
        }
        if (!searchpath.getKey().equals("") && !searchpath.getValue().equals("")) {
            filename = FileUtil.cutExtension((String)searchpath.getValue()).getKey();
            filename = filename.replace('/', '.');
            if ((filename = filename.replace('\\', '.')).charAt(0) == '.') {
                filename = filename.substring(1);
            }
            try {
                ret = Class.forName(filename);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static void main(String[] stringArray) {
        ClassFileFilterIsA classFileFilterIsA = new ClassFileFilterIsA();
        System.out.println("Adding interface: " + FileFilter.class.getName() + " to instance test (" + classFileFilterIsA.getClass().getName() + ")");
        classFileFilterIsA.addSuperClass(FileFilter.class);
        System.out.println("test.accept(" + classFileFilterIsA.getClass().getName() + " : " + classFileFilterIsA.accept(classFileFilterIsA.getClass()));
        System.out.println("test.accept(new File(\"bin/cpdetector/io/ClassfileFilterIsA.class\").getAbsoluteFile()) : " + classFileFilterIsA.accept(new File("bin/cpdetector/io/ClassfileFilterIsA.class").getAbsoluteFile()));
    }
}

