/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.cpdetector.io;

import info.monitorenter.cpdetector.io.AbstractCodepageDetector;
import info.monitorenter.cpdetector.io.ICodepageDetector;
import info.monitorenter.cpdetector.io.UnknownCharset;
import info.monitorenter.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

public final class ASCIIDetector
extends AbstractCodepageDetector {
    private static ICodepageDetector instance;

    private ASCIIDetector() {
    }

    public static ICodepageDetector getInstance() {
        if (instance == null) {
            instance = new ASCIIDetector();
        }
        return instance;
    }

    public Charset detectCodepage(InputStream in, int length) throws IOException {
        Charset ret = UnknownCharset.getInstance();
        InputStream localin = !(in instanceof BufferedInputStream) ? new BufferedInputStream(in, 4096) : in;
        if (FileUtil.isAllASCII(localin)) {
            ret = Charset.forName("US-ASCII");
        }
        return ret;
    }
}

