/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.htmlcompressor.analyzer;

import com.googlecode.htmlcompressor.compressor.ClosureJavaScriptCompressor;
import com.googlecode.htmlcompressor.compressor.HtmlCompressor;
import java.text.NumberFormat;
import java.util.Formatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlAnalyzer {
    private static final Logger logger = LoggerFactory.getLogger(HtmlAnalyzer.class);
    private String jsCompressor = "yui";

    public HtmlAnalyzer() {
    }

    public HtmlAnalyzer(String jsCompressor) {
        this.jsCompressor = jsCompressor;
    }

    public void analyze(String source) {
        int originalSize = source.length();
        HtmlCompressor compressor = this.getCleanCompressor();
        String compResult = compressor.compress(source);
        this.printHeader();
        logger.info(this.formatLine("Compression disabled", originalSize, originalSize, originalSize));
        int prevSize = originalSize;
        logger.info(this.formatLine("All settings disabled", originalSize, compResult.length(), prevSize));
        prevSize = compResult.length();
        compressor.setRemoveComments(true);
        compResult = compressor.compress(source);
        logger.info(this.formatLine("Comments removed", originalSize, compResult.length(), prevSize));
        prevSize = compResult.length();
        compressor.setRemoveMultiSpaces(true);
        compResult = compressor.compress(source);
        logger.info(this.formatLine("Multiple spaces removed", originalSize, compResult.length(), prevSize));
        prevSize = compResult.length();
        compressor.setRemoveIntertagSpaces(true);
        compResult = compressor.compress(source);
        logger.info(this.formatLine("No spaces between tags", originalSize, compResult.length(), prevSize));
        prevSize = compResult.length();
        compressor.setRemoveSurroundingSpaces("html,head,body,br,p");
        compResult = compressor.compress(source);
        logger.info(this.formatLine("No surround spaces (min)", originalSize, compResult.length(), prevSize));
        prevSize = compResult.length();
        compressor.setRemoveSurroundingSpaces("html,head,body,br,p,h1,h2,h3,h4,h5,h6,blockquote,center,dl,fieldset,form,frame,frameset,hr,noframes,ol,table,tbody,tr,td,th,tfoot,thead,ul");
        compResult = compressor.compress(source);
        logger.info(this.formatLine("No surround spaces (max)", originalSize, compResult.length(), prevSize));
        prevSize = compResult.length();
        compressor.setRemoveSurroundingSpaces("all");
        compResult = compressor.compress(source);
        logger.info(this.formatLine("No surround spaces (all)", originalSize, compResult.length(), prevSize));
        prevSize = compResult.length();
        compressor.setRemoveQuotes(true);
        compResult = compressor.compress(source);
        logger.info(this.formatLine("Quotes removed from tags", originalSize, compResult.length(), prevSize));
        prevSize = compResult.length();
        compressor.setRemoveLinkAttributes(true);
        compResult = compressor.compress(source);
        logger.info(this.formatLine("<link> attr. removed", originalSize, compResult.length(), prevSize));
        prevSize = compResult.length();
        compressor.setRemoveStyleAttributes(true);
        compResult = compressor.compress(source);
        logger.info(this.formatLine("<style> attr. removed", originalSize, compResult.length(), prevSize));
        prevSize = compResult.length();
        compressor.setRemoveScriptAttributes(true);
        compResult = compressor.compress(source);
        logger.info(this.formatLine("<script> attr. removed", originalSize, compResult.length(), prevSize));
        prevSize = compResult.length();
        compressor.setRemoveFormAttributes(true);
        compResult = compressor.compress(source);
        logger.info(this.formatLine("<form> attr. removed", originalSize, compResult.length(), prevSize));
        prevSize = compResult.length();
        compressor.setRemoveInputAttributes(true);
        compResult = compressor.compress(source);
        logger.info(this.formatLine("<input> attr. removed", originalSize, compResult.length(), prevSize));
        prevSize = compResult.length();
        compressor.setSimpleBooleanAttributes(true);
        compResult = compressor.compress(source);
        logger.info(this.formatLine("Simple boolean attributes", originalSize, compResult.length(), prevSize));
        prevSize = compResult.length();
        compressor.setSimpleDoctype(true);
        compResult = compressor.compress(source);
        logger.info(this.formatLine("Simple doctype", originalSize, compResult.length(), prevSize));
        prevSize = compResult.length();
        compressor.setRemoveJavaScriptProtocol(true);
        compResult = compressor.compress(source);
        logger.info(this.formatLine("Remove js pseudo-protocol", originalSize, compResult.length(), prevSize));
        prevSize = compResult.length();
        compressor.setRemoveHttpProtocol(true);
        compResult = compressor.compress(source);
        logger.info(this.formatLine("Remove http protocol", originalSize, compResult.length(), prevSize));
        prevSize = compResult.length();
        compressor.setRemoveHttpsProtocol(true);
        compResult = compressor.compress(source);
        logger.info(this.formatLine("Remove https protocol", originalSize, compResult.length(), prevSize));
        prevSize = compResult.length();
        try {
            compressor.setCompressCss(true);
            compResult = compressor.compress(source);
            logger.info(this.formatLine("Compress inline CSS (YUI)", originalSize, compResult.length(), prevSize));
            prevSize = compResult.length();
        }
        catch (NoClassDefFoundError e) {
            logger.info(this.formatEmptyLine("Compress inline CSS (YUI)"));
            logger.trace("", (Throwable)e);
        }
        if (this.jsCompressor.equals("yui")) {
            try {
                compressor.setCompressJavaScript(true);
                compResult = compressor.compress(source);
                logger.info(this.formatLine("Compress inline JS (YUI)", originalSize, compResult.length(), prevSize));
            }
            catch (NoClassDefFoundError e) {
                logger.info(this.formatEmptyLine("Compress inline JS (YUI)"));
                logger.trace("", (Throwable)e);
            }
        } else {
            try {
                compressor.setCompressJavaScript(true);
                compressor.setJavaScriptCompressor(new ClosureJavaScriptCompressor());
                compResult = compressor.compress(source);
                logger.info(this.formatLine("Compress JS (Closure)", originalSize, compResult.length(), prevSize));
            }
            catch (NoClassDefFoundError e) {
                logger.info(this.formatEmptyLine("Compress JS (Closure)"));
                logger.trace("", (Throwable)e);
            }
        }
        this.printFooter();
    }

    private HtmlCompressor getCleanCompressor() {
        HtmlCompressor compressor = new HtmlCompressor();
        compressor.setRemoveComments(false);
        compressor.setRemoveMultiSpaces(false);
        return compressor;
    }

    private String formatLine(String descr, int originalSize, int compressedSize, int prevSize) {
        String result;
        try (Formatter fmt = new Formatter();){
            fmt.format("%-25s | %16s | %16s | %12s |", descr, this.formatDecrease(prevSize, compressedSize), this.formatDecrease(originalSize, compressedSize), this.formatSize(compressedSize));
            result = fmt.toString();
        }
        return result;
    }

    private String formatEmptyLine(String descr) {
        String result;
        try (Formatter fmt = new Formatter();){
            fmt.format("%-25s | %16s | %16s | %12s |", descr, "-", "-", "-");
            result = fmt.toString();
        }
        return result;
    }

    private void printHeader() {
        logger.info("\n");
        logger.info("=".repeat(80));
        logger.info(String.format("%-25s | %-16s | %-16s | %-12s |", "         Setting", "Incremental Gain", "   Total Gain", " Page Size"));
        logger.info("\n");
        logger.info("=".repeat(80));
    }

    private void printFooter() {
        logger.info("=".repeat(80));
        logger.info("\n");
        logger.info("Each consecutive compressor setting is applied on top of previous ones.");
        logger.info("In order to see JS and CSS compression results, YUI jar file must be present.");
        logger.info("All sizes are in bytes.");
    }

    private String formatDecrease(int originalSize, int compressedSize) {
        NumberFormat nf = NumberFormat.getPercentInstance();
        nf.setGroupingUsed(true);
        nf.setMinimumFractionDigits(1);
        nf.setMaximumFractionDigits(1);
        return this.formatSize(originalSize - compressedSize) + " (" + nf.format(1.0 - (double)compressedSize / (double)originalSize) + ")";
    }

    private String formatSize(int size) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(true);
        nf.setParseIntegerOnly(true);
        return nf.format(size);
    }
}

