/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.rsync4j;

import com.github.fracpete.rsync4j.SshPass;
import com.github.fracpete.rsync4j.core.AbstractBinaryWithTimeout;
import com.github.fracpete.rsync4j.core.Binaries;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.FeatureControl;
import net.sourceforge.argparse4j.inf.Namespace;

public class Ssh
extends AbstractBinaryWithTimeout {
    protected boolean version1;
    protected boolean version2;
    protected boolean ipv4;
    protected boolean ipv6;
    protected Boolean forwardAgent;
    protected String bindAddress;
    protected boolean compression;
    protected String cipherSpec;
    protected String dynamicBindAddress;
    protected String logFile;
    protected String escapeChar;
    protected String configFile;
    protected boolean background;
    protected boolean printConfig;
    protected boolean allowRemoteConnect;
    protected String pkcs11;
    protected String identifyFile;
    protected Boolean gssapi;
    protected String local;
    protected String loginName;
    protected boolean masterMode;
    protected String macSpec;
    protected boolean noRemoteExecute;
    protected boolean fromNull;
    protected String controlCommand;
    protected List<String> option;
    protected int port;
    protected String queryOption;
    protected boolean quiet;
    protected String remote;
    protected String controlSocket;
    protected boolean subsystem;
    protected Boolean terminal;
    protected boolean version;
    protected int verbose;
    protected String forwardTo;
    protected String forwardTunnel;
    protected Boolean x11;
    protected boolean trustedX11;
    protected boolean syslog;
    protected String hostname;
    protected String command;
    protected SshPass sshPass;

    @Override
    public void reset() {
        super.reset();
        this.version1 = false;
        this.version2 = false;
        this.ipv4 = false;
        this.ipv6 = false;
        this.forwardAgent = null;
        this.bindAddress = "";
        this.compression = false;
        this.cipherSpec = "";
        this.dynamicBindAddress = "";
        this.logFile = "";
        this.escapeChar = "";
        this.configFile = "";
        this.background = false;
        this.printConfig = false;
        this.allowRemoteConnect = false;
        this.pkcs11 = "";
        this.identifyFile = "";
        this.gssapi = null;
        this.local = "";
        this.loginName = "";
        this.masterMode = false;
        this.macSpec = "";
        this.noRemoteExecute = false;
        this.fromNull = false;
        this.controlCommand = "";
        this.option = new ArrayList<String>();
        this.port = -1;
        this.queryOption = "";
        this.quiet = false;
        this.remote = "";
        this.controlSocket = "";
        this.subsystem = false;
        this.terminal = null;
        this.version = false;
        this.verbose = 0;
        this.forwardTo = "";
        this.forwardTunnel = "";
        this.x11 = null;
        this.trustedX11 = false;
        this.syslog = false;
        this.hostname = "";
        this.command = "";
        this.sshPass = null;
    }

    @Override
    public Ssh outputCommandline(boolean value) {
        return (Ssh)super.outputCommandline(value);
    }

    public Ssh version1(boolean value) {
        this.version1 = value;
        return this;
    }

    public boolean getVersion1() {
        return this.version1;
    }

    public Ssh version2(boolean value) {
        this.version2 = value;
        return this;
    }

    public boolean getVersion2() {
        return this.version2;
    }

    public Ssh ipv4(boolean value) {
        this.ipv4 = value;
        return this;
    }

    public boolean getIpv4() {
        return this.ipv4;
    }

    public Ssh ipv6(boolean value) {
        this.ipv6 = value;
        return this;
    }

    public boolean getIpv6() {
        return this.ipv6;
    }

    public Ssh forwardAgent(Boolean value) {
        this.forwardAgent = value;
        return this;
    }

    public Boolean getForwardAgent() {
        return this.forwardAgent;
    }

    public Ssh bindAddress(String value) {
        this.bindAddress = value;
        return this;
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public Ssh compression(boolean value) {
        this.compression = value;
        return this;
    }

    public boolean getCompression() {
        return this.compression;
    }

    public Ssh cipherSpec(String value) {
        this.cipherSpec = value;
        return this;
    }

    public String getCipherSpec() {
        return this.cipherSpec;
    }

    public Ssh dynamicBindAddress(String value) {
        this.dynamicBindAddress = value;
        return this;
    }

    public String getDynamicBindAddress() {
        return this.dynamicBindAddress;
    }

    public Ssh logFile(String value) {
        this.logFile = value;
        return this;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public Ssh escapeChar(String value) {
        this.escapeChar = value;
        return this;
    }

    public String getEscapeChar() {
        return this.escapeChar;
    }

    public Ssh configFile(String value) {
        this.configFile = value;
        return this;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public Ssh background(boolean value) {
        this.background = value;
        return this;
    }

    public boolean getBackground() {
        return this.background;
    }

    public Ssh printConfig(boolean value) {
        this.printConfig = value;
        return this;
    }

    public boolean getPrintConfig() {
        return this.printConfig;
    }

    public Ssh allowRemoteConnect(boolean value) {
        this.allowRemoteConnect = value;
        return this;
    }

    public boolean getAllowRemoteConnect() {
        return this.allowRemoteConnect;
    }

    public Ssh pkcs11(String value) {
        this.pkcs11 = value;
        return this;
    }

    public String getPkcs11() {
        return this.pkcs11;
    }

    public Ssh identifyFile(String value) {
        this.identifyFile = value;
        return this;
    }

    public String getIdentifyFile() {
        return this.identifyFile;
    }

    public Ssh gssapi(Boolean value) {
        this.gssapi = value;
        return this;
    }

    public Boolean getGssapi() {
        return this.gssapi;
    }

    public Ssh local(String value) {
        this.local = value;
        return this;
    }

    public String getLocal() {
        return this.local;
    }

    public Ssh loginName(String value) {
        this.loginName = value;
        return this;
    }

    public String getLoginName() {
        return this.loginName;
    }

    public Ssh masterMode(boolean value) {
        this.masterMode = value;
        return this;
    }

    public boolean getMasterMode() {
        return this.masterMode;
    }

    public Ssh macSpec(String value) {
        this.macSpec = value;
        return this;
    }

    public String getMacSpec() {
        return this.macSpec;
    }

    public Ssh noRemoteExecute(boolean value) {
        this.noRemoteExecute = value;
        return this;
    }

    public boolean getNoRemoteExecute() {
        return this.noRemoteExecute;
    }

    public Ssh fromNull(boolean value) {
        this.fromNull = value;
        return this;
    }

    public boolean getFromNull() {
        return this.fromNull;
    }

    public Ssh controlCommand(String value) {
        this.controlCommand = value;
        return this;
    }

    public String getControlCommand() {
        return this.controlCommand;
    }

    public Ssh option(String ... value) {
        this.option = new ArrayList<String>(Arrays.asList(value));
        return this;
    }

    public Ssh option(List<String> value) {
        this.option = new ArrayList<String>(value);
        return this;
    }

    public List<String> getOption() {
        return this.option;
    }

    public Ssh port(int value) {
        if (value == -1 || value > 0 && value < 65536) {
            this.port = value;
        }
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public Ssh queryOption(String value) {
        this.queryOption = value;
        return this;
    }

    public String getQueryOption() {
        return this.queryOption;
    }

    public Ssh quiet(boolean value) {
        this.quiet = value;
        return this;
    }

    public boolean getQuiet() {
        return this.quiet;
    }

    public Ssh remote(String value) {
        this.remote = value;
        return this;
    }

    public String getRemote() {
        return this.remote;
    }

    public Ssh controlSocket(String value) {
        this.controlSocket = value;
        return this;
    }

    public String getControlSocket() {
        return this.controlSocket;
    }

    public Ssh subsystem(boolean value) {
        this.subsystem = value;
        return this;
    }

    public boolean getSubsystem() {
        return this.subsystem;
    }

    public Ssh terminal(Boolean value) {
        this.terminal = value;
        return this;
    }

    public Boolean getTerminal() {
        return this.terminal;
    }

    public Ssh version(boolean value) {
        this.version = value;
        return this;
    }

    public boolean getVersion() {
        return this.version;
    }

    public Ssh verbose(int value) {
        if (value >= 0) {
            this.verbose = value;
        }
        return this;
    }

    public int getVerbose() {
        return this.verbose;
    }

    public Ssh forwardTo(String value) {
        this.forwardTo = value;
        return this;
    }

    public String getForwardTo() {
        return this.forwardTo;
    }

    public Ssh forwardTunnel(String value) {
        this.forwardTunnel = value;
        return this;
    }

    public String getForwardTunnel() {
        return this.forwardTunnel;
    }

    public Ssh x11(Boolean value) {
        this.x11 = value;
        return this;
    }

    public Boolean getX11() {
        return this.x11;
    }

    public Ssh trustedX11(boolean value) {
        this.trustedX11 = value;
        return this;
    }

    public boolean getTrustedX11() {
        return this.trustedX11;
    }

    public Ssh syslog(boolean value) {
        this.syslog = value;
        return this;
    }

    public boolean getSyslog() {
        return this.syslog;
    }

    public Ssh hostname(String value) {
        this.hostname = value;
        return this;
    }

    public String getHostname() {
        return this.hostname;
    }

    public Ssh command(String value) {
        this.command = value;
        return this;
    }

    public String getCommand() {
        return this.command;
    }

    public Ssh sshPass(SshPass value) {
        this.sshPass = value;
        return this;
    }

    public SshPass getSshPass() {
        return this.sshPass;
    }

    @Override
    public List<String> options() throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        if (this.getVersion1()) {
            result.add("-1");
        }
        if (this.getVersion2()) {
            result.add("-2");
        }
        if (this.getIpv4()) {
            result.add("-4");
        }
        if (this.getIpv6()) {
            result.add("-6");
        }
        if (this.getForwardAgent() != null) {
            if (this.getForwardAgent().booleanValue()) {
                result.add("-A");
            } else {
                result.add("-a");
            }
        }
        if (!this.getBindAddress().isEmpty()) {
            result.add("-b");
            result.add(this.getBindAddress());
        }
        if (this.getCompression()) {
            result.add("-C");
        }
        if (!this.getCipherSpec().isEmpty()) {
            result.add("-c");
            result.add(this.getCipherSpec());
        }
        if (!this.getDynamicBindAddress().isEmpty()) {
            result.add("-D");
            result.add(this.getDynamicBindAddress());
        }
        if (!this.getLogFile().isEmpty()) {
            result.add("-E");
            result.add(this.getLogFile());
        }
        if (!this.getEscapeChar().isEmpty()) {
            result.add("-e");
            result.add(this.getEscapeChar());
        }
        if (!this.getConfigFile().isEmpty()) {
            result.add("-F");
            result.add(this.getConfigFile());
        }
        if (this.getBackground()) {
            result.add("-f");
        }
        if (this.getPrintConfig()) {
            result.add("-G");
        }
        if (this.getAllowRemoteConnect()) {
            result.add("-g");
        }
        if (!this.getPkcs11().isEmpty()) {
            result.add("-I");
            result.add(this.getPkcs11());
        }
        if (!this.getIdentifyFile().isEmpty()) {
            result.add("-i");
            result.add(this.getIdentifyFile());
        }
        if (this.getGssapi() != null) {
            if (this.getGssapi().booleanValue()) {
                result.add("-K");
            } else {
                result.add("-k");
            }
        }
        if (!this.getLocal().isEmpty()) {
            result.add("-L");
            result.add(this.getLocal());
        }
        if (!this.getLoginName().isEmpty()) {
            result.add("-l");
            result.add(this.getLoginName());
        }
        if (this.getMasterMode()) {
            result.add("-M");
        }
        if (!this.getMacSpec().isEmpty()) {
            result.add("-m");
            result.add(this.getMacSpec());
        }
        if (this.getNoRemoteExecute()) {
            result.add("-N");
        }
        if (this.getFromNull()) {
            result.add("-n");
        }
        if (!this.getControlCommand().isEmpty()) {
            result.add("-O");
            result.add(this.getControlCommand());
        }
        for (String o : this.getOption()) {
            result.add("-o");
            result.add(o);
        }
        if (this.getPort() > -1) {
            result.add("-p");
            result.add("" + this.getPort());
        }
        if (!this.getQueryOption().isEmpty()) {
            result.add("-Q");
            result.add(this.getQueryOption());
        }
        if (this.getQuiet()) {
            result.add("-q");
        }
        if (!this.getRemote().isEmpty()) {
            result.add("-R");
            result.add(this.getRemote());
        }
        if (!this.getControlSocket().isEmpty()) {
            result.add("-S");
            result.add(this.getControlSocket());
        }
        if (this.getSubsystem()) {
            result.add("-s");
        }
        if (this.getTerminal() != null) {
            if (this.getTerminal().booleanValue()) {
                result.add("-t");
            } else {
                result.add("-T");
            }
        }
        if (this.getVersion()) {
            result.add("-V");
        }
        if (this.getVerbose() == 1) {
            result.add("-v");
        }
        if (this.getVerbose() == 2) {
            result.add("-vv");
        }
        if (this.getVerbose() == 3) {
            result.add("-vvv");
        }
        if (!this.getForwardTo().isEmpty()) {
            result.add("-W");
            result.add(this.getForwardTo());
        }
        if (!this.getForwardTunnel().isEmpty()) {
            result.add("-w");
            result.add(this.getForwardTunnel());
        }
        if (this.getX11() != null) {
            if (this.getX11().booleanValue()) {
                result.add("-X");
            } else {
                result.add("-x");
            }
        }
        if (this.getTrustedX11()) {
            result.add("-Y");
        }
        if (this.getSyslog()) {
            result.add("-y");
        }
        result.add(this.getHostname());
        if (!this.getCommand().isEmpty()) {
            result.add(this.getCommand());
        }
        return result;
    }

    @Override
    public List<String> commandLineArgs() throws Exception {
        String binary = Binaries.sshBinary();
        List<String> result = this.options();
        result.add(0, binary);
        if (this.getSshPass() != null) {
            List<String> sshPassArgs = this.getSshPass().commandLineArgs();
            for (int i = sshPassArgs.size() - 1; i >= 0; --i) {
                result.add(0, sshPassArgs.get(i));
            }
        }
        return result;
    }

    @Override
    protected String description() {
        return "OpenSSH SSH client (remote login program). No interactive sessions possible.\nSee man page:\nhttps://linux.die.net/man/1/ssh";
    }

    @Override
    protected ArgumentParser getParser() {
        ArgumentParser parser = super.getParser();
        parser.addArgument(new String[]{"-1"}).dest("version1").help("Forces ssh to try protocol version 1 only.").setDefault((Object)false).action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-2"}).dest("version2").help("Forces ssh to try protocol version 2 only.").setDefault((Object)false).action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-4"}).dest("ipv4").help("Forces ssh to use IPv4 addresses only.").setDefault((Object)false).action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-6"}).dest("ipv6").help("Forces ssh to use IPv6 addresses only.").setDefault((Object)false).action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-A"}).dest("forwardAgent").help("Enables forwarding of the authentication agent connection.").setDefault(FeatureControl.SUPPRESS).action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-a"}).dest("forwardAgent").help("Disables forwarding of the authentication agent connection.").setDefault(FeatureControl.SUPPRESS).action((ArgumentAction)Arguments.storeFalse());
        parser.addArgument(new String[]{"-b"}).dest("bindAddress").help("Use bind_address on the local machine as the source address of the connection.").setDefault((Object)"");
        parser.addArgument(new String[]{"-C"}).dest("compression").help("Requests compression of all data.").setDefault((Object)false).action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-c"}).dest("cipherSpec").help("Selects the cipher specification for encrypting the session.").setDefault((Object)"");
        parser.addArgument(new String[]{"-D"}).dest("dynamicBindAddress").help("Specifies a local \u201cdynamic\u201d application-level port forwarding ([bind_address:]port).").setDefault((Object)"");
        parser.addArgument(new String[]{"-E"}).dest("logFile").help("Append debug logs to log_file instead of standard error.").setDefault((Object)"");
        parser.addArgument(new String[]{"-e"}).dest("escapeChar").help("Sets the escape character for sessions with a pty (default: \u2018~\u2019).").setDefault((Object)Character.valueOf('\u0000'));
        parser.addArgument(new String[]{"-F"}).dest("configFile").help("Specifies an alternative per-user configuration file.").setDefault((Object)"");
        parser.addArgument(new String[]{"-f"}).dest("background").help("Requests ssh to go to background just before command execution.").setDefault((Object)false).action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-G"}).dest("printConfig").help("Causes ssh to print its configuration after evaluating Host and Match blocks and exit.").setDefault((Object)false).action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-g"}).dest("allowRemoteConnect").help("Allows remote hosts to connect to local forwarded ports").setDefault((Object)false).action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-I"}).dest("pkcs11").help("Specify the PKCS#11 shared library ssh should use to communicate with a PKCS#11 token providing the user's private RSA key.").setDefault((Object)"");
        parser.addArgument(new String[]{"-K"}).dest("gssapi").help("Enables GSSAPI-based authentication and forwarding (delegation) of GSSAPI credentials to the server.").setDefault(FeatureControl.SUPPRESS).action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-k"}).dest("gssapi").help("Disables forwarding (delegation) of GSSAPI credentials to the server.").setDefault(FeatureControl.SUPPRESS).action((ArgumentAction)Arguments.storeFalse());
        parser.addArgument(new String[]{"-L"}).dest("local").help("Specifies that connections to the given TCP port or Unix socket on the local (client) host are to be forwarded to the given host and port, or Unix socket, on the remote side.").setDefault((Object)"");
        parser.addArgument(new String[]{"-l"}).dest("loginName").help("Specifies the user to log in as on the remote machine.").setDefault((Object)"");
        parser.addArgument(new String[]{"-M"}).dest("masterMode").help("Places the ssh client into \u201cmaster\u201d mode for connection sharing.").setDefault((Object)false).action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-m"}).dest("macSpec").help("A comma-separated list of MAC (message authentication code) algorithms, specified in order of preference.").setDefault((Object)"");
        parser.addArgument(new String[]{"-N"}).dest("noRemoteExecute").help("Do not execute a remote command. This is useful for just forwarding ports.").setDefault((Object)false).action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-n"}).dest("fromNull").help("Redirects stdin from /dev/null (actually, prevents reading from stdin).").setDefault((Object)false).action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-O"}).dest("controlCommand").help("Control an active connection multiplexing master process.").setDefault((Object)"");
        parser.addArgument(new String[]{"-o"}).dest("option").help("Can be used to give options in the format used in the configuration file.").setDefault(new ArrayList());
        parser.addArgument(new String[]{"-p"}).dest("port").help("Port to connect to on the remote host.").setDefault((Object)-1);
        parser.addArgument(new String[]{"-q"}).dest("quiet").help("Quiet mode. Causes most warning and diagnostic messages to be suppressed.").setDefault((Object)false).action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-R"}).dest("remote").help("Specifies that connections to the given TCP port or Unix socket on the remote (server) host are to be forwarded to the given host and port, or Unix socket, on the local side.").setDefault((Object)"");
        parser.addArgument(new String[]{"-s"}).dest("subsystem").help("May be used to request invocation of a subsystem on the remote system.").setDefault((Object)false).action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-T"}).dest("terminal").help("Disable pseudo-terminal allocation.").setDefault(FeatureControl.SUPPRESS).action((ArgumentAction)Arguments.storeFalse());
        parser.addArgument(new String[]{"-t"}).dest("terminal").help("Force pseudo-terminal allocation.").setDefault(FeatureControl.SUPPRESS).action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-v"}).dest("verbose").help("Verbose mode.").action((ArgumentAction)Arguments.storeConst()).setConst((Object)1).setDefault((Object)0);
        parser.addArgument(new String[]{"-vv"}).dest("verbose").help("Very verbose mode.").action((ArgumentAction)Arguments.storeConst()).setConst((Object)2).setDefault((Object)0);
        parser.addArgument(new String[]{"-vvv"}).dest("verbose").help("Very, very verbose mode.").action((ArgumentAction)Arguments.storeConst()).setConst((Object)3).setDefault((Object)0);
        parser.addArgument(new String[]{"-W"}).dest("forwardTo").help("Requests that standard input and output on the client be forwarded to host on port over the secure channel.").setDefault((Object)"");
        parser.addArgument(new String[]{"-w"}).dest("forwardTunnel").help("Requests tunnel device forwarding with the specified tun(4) devices between the client (local_tun) and the server (remote_tun).").setDefault((Object)"");
        parser.addArgument(new String[]{"-X"}).dest("x11").help("Enables X11 forwarding.").setDefault(FeatureControl.SUPPRESS).action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-x"}).dest("x11").help("Disables X11 forwarding.").setDefault(FeatureControl.SUPPRESS).action((ArgumentAction)Arguments.storeFalse());
        parser.addArgument(new String[]{"-Y"}).dest("trustedX11").help("Enables trusted X11 forwarding.").setDefault((Object)false).action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-y"}).dest("syslog").help("Send log information using the syslog system module.").setDefault((Object)false).action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{""}).dest("hostname").required(true).help("The hostname to connect to.");
        parser.addArgument(new String[]{"hostname"}).metavar(new String[]{""}).dest("hostname").required(true).help("The hostname to connect to.");
        parser.addArgument(new String[]{"command"}).nargs("?").dest("command").required(false).help("The remote command to execute.");
        return parser;
    }

    @Override
    protected boolean setOptions(Namespace ns) {
        boolean result = super.setOptions(ns);
        if (!result) {
            return false;
        }
        this.verbose(ns.getInt("verbose"));
        this.version1(ns.getBoolean("version1"));
        this.version2(ns.getBoolean("version2"));
        this.ipv4(ns.getBoolean("ipv4"));
        this.ipv6(ns.getBoolean("ipv6"));
        this.forwardAgent(ns.getBoolean("forwardAgent"));
        this.bindAddress(ns.getString("bindAddress"));
        this.compression(ns.getBoolean("compression"));
        this.cipherSpec(ns.getString("cipherSpec"));
        this.dynamicBindAddress(ns.getString("dynamicBindAddress"));
        this.logFile(ns.getString("logFile"));
        this.escapeChar((String)ns.get("escapeChar"));
        this.configFile(ns.getString("configFile"));
        this.background(ns.getBoolean("background"));
        this.printConfig(ns.getBoolean("printConfig"));
        this.allowRemoteConnect(ns.getBoolean("allowRemoteConnect"));
        this.pkcs11(ns.getString("pkcs11"));
        this.identifyFile(ns.getString("identifyFile"));
        this.gssapi(ns.getBoolean("gssapi"));
        this.local(ns.getString("local"));
        this.loginName(ns.getString("loginName"));
        this.masterMode(ns.getBoolean("masterMode"));
        this.macSpec(ns.getString("macSpec"));
        this.noRemoteExecute(ns.getBoolean("noRemoteExecute"));
        this.fromNull(ns.getBoolean("fromNull"));
        this.controlCommand(ns.getString("controlCommand"));
        this.option(ns.getList("option"));
        this.port(ns.getInt("port"));
        this.queryOption(ns.getString("queryOption"));
        this.quiet(ns.getBoolean("quiet"));
        this.remote(ns.getString("remote"));
        this.controlSocket(ns.getString("controlSocket"));
        this.subsystem(ns.getBoolean("subsystem"));
        this.terminal(ns.getBoolean("terminal"));
        this.version(ns.getBoolean("version"));
        this.forwardTo(ns.getString("forwardTo"));
        this.forwardTunnel(ns.getString("forwardTunnel"));
        this.x11(ns.getBoolean("x11"));
        this.trustedX11(ns.getBoolean("trustedX11"));
        this.syslog(ns.getBoolean("syslog"));
        return true;
    }

    public static void main(String[] args) throws Exception {
        Ssh.run(new Ssh(), args);
    }
}

