/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.processoutput4j.output;

import com.github.fracpete.processoutput4j.output.AbstractProcessOutput;
import com.github.fracpete.processoutput4j.reader.AbstractProcessReader;
import com.github.fracpete.processoutput4j.reader.CollectingProcessReader;
import java.util.Arrays;

public final class CollectingProcessOutput
extends AbstractProcessOutput {
    private static final long serialVersionUID = 1902809285333524039L;
    protected StringBuilder m_StdOut;
    protected StringBuilder m_StdErr;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_StdOut = new StringBuilder();
        this.m_StdErr = new StringBuilder();
    }

    @Override
    protected AbstractProcessReader configureStdErr() {
        return new CollectingProcessReader(false, this.m_StdErr);
    }

    @Override
    protected AbstractProcessReader configureStdOut() {
        return new CollectingProcessReader(true, this.m_StdOut);
    }

    public String getStdOut() {
        return this.m_StdOut.toString();
    }

    public String getStdErr() {
        return this.m_StdErr.toString();
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("No command (+ options) provided!");
            System.exit(1);
        }
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command(args);
        CollectingProcessOutput out = new CollectingProcessOutput();
        out.monitor(builder);
        System.out.println();
        System.out.println("Command:");
        System.out.println(Arrays.asList(args));
        System.out.println("Exit code:");
        System.out.println(out.getExitCode());
        System.out.println("StdOut:");
        System.out.println(out.getStdOut());
        System.err.println("StdErr:");
        System.err.println(out.getStdErr());
    }
}

