/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.processoutput4j.output;

import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.io.Serializable;

public abstract class AbstractProcessOutput
implements Serializable {
    private static final long serialVersionUID = 1902809285333524039L;
    protected String[] m_Command;
    protected String[] m_Environment;
    protected int m_ExitCode;
    protected transient Process m_Process;
    protected int m_TimeOut;
    protected boolean m_TimedOut;

    public AbstractProcessOutput() {
        this.initialize();
    }

    protected void initialize() {
        this.m_Command = new String[0];
        this.m_Environment = null;
        this.m_ExitCode = 0;
        this.m_Process = null;
        this.m_TimeOut = -1;
        this.m_TimedOut = false;
    }

    public void setTimeOut(int value) {
        if (value < 1) {
            value = -1;
        }
        this.m_TimeOut = value;
    }

    public int getTimeOut() {
        return this.m_TimeOut;
    }

    public void monitor(ProcessBuilder builder) throws Exception {
        this.monitor(null, builder);
    }

    public void monitor(String input, ProcessBuilder builder) throws Exception {
        this.monitor(builder.command().toArray(new String[0]), null, input, builder.start());
    }

    public void monitor(String cmd, String[] env, Process process) throws Exception {
        this.monitor(cmd, env, null, process);
    }

    public void monitor(String cmd, String[] env, String input, Process process) throws Exception {
        this.monitor(new String[]{cmd}, env, input, process);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void monitor(String[] cmd, String[] env, String input, Process process) throws Exception {
        this.m_Command = cmd;
        this.m_Environment = env;
        this.m_Process = process;
        this.m_TimedOut = false;
        Thread threade = this.configureStdErr(this.m_Process);
        threade.start();
        Thread threado = this.configureStdOut(this.m_Process);
        threado.start();
        if (this.m_TimeOut > 0) {
            Thread threadt = this.configureTimeOutMonitor(this.m_Process);
            threadt.start();
        }
        if (input != null) {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(this.m_Process.getOutputStream()));
            writer.write(input);
            writer.close();
        }
        this.m_ExitCode = this.m_Process.waitFor();
        while (threade.isAlive() || threado.isAlive()) {
            try {
                AbstractProcessOutput abstractProcessOutput = this;
                synchronized (abstractProcessOutput) {
                    this.wait(100L);
                }
            }
            catch (Exception exception) {
            }
        }
        this.m_Process = null;
    }

    protected abstract Thread configureStdErr(Process var1);

    protected abstract Thread configureStdOut(Process var1);

    protected Thread configureTimeOutMonitor(Process process) {
        return new Thread(() -> {
            long start = System.currentTimeMillis();
            while (process.isAlive()) {
                try {
                    AbstractProcessOutput abstractProcessOutput = this;
                    synchronized (abstractProcessOutput) {
                        this.wait(500L);
                    }
                    if (!process.isAlive() || (System.currentTimeMillis() - start) / 1000L < (long)this.m_TimeOut) continue;
                    this.m_TimedOut = true;
                    System.err.println("Timeout of " + this.m_TimeOut + " seconds reached, terminating process...");
                    process.destroy();
                    break;
                }
                catch (Exception exception) {
                }
            }
        });
    }

    public String[] getCommand() {
        return this.m_Command;
    }

    public String[] getEnvironment() {
        return this.m_Environment;
    }

    public boolean hasSucceeded() {
        return this.m_ExitCode == 0 && !this.hasTimedOut();
    }

    public int getExitCode() {
        return this.m_ExitCode;
    }

    public boolean hasTimedOut() {
        return this.m_TimedOut;
    }

    public Process getProcess() {
        return this.m_Process;
    }

    public void destroy() {
        if (this.m_Process != null) {
            this.m_Process.destroy();
        }
    }

    public String toString() {
        return "exit code=" + this.m_ExitCode;
    }
}

