/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.CacheDescriptor;
import com.github.eirslett.maven.plugins.frontend.lib.CacheResolver;
import java.io.File;

public class DirectoryCacheResolver
implements CacheResolver {
    private final File cacheDirectory;

    public DirectoryCacheResolver(File cacheDirectory) {
        this.cacheDirectory = cacheDirectory;
    }

    @Override
    public File resolve(CacheDescriptor cacheDescriptor) {
        if (!this.cacheDirectory.exists()) {
            this.cacheDirectory.mkdirs();
        }
        StringBuilder filename = new StringBuilder().append(cacheDescriptor.getName()).append("-").append(cacheDescriptor.getVersion());
        if (cacheDescriptor.getClassifier() != null) {
            filename.append("-").append(cacheDescriptor.getClassifier());
        }
        filename.append(".").append(cacheDescriptor.getExtension());
        return new File(this.cacheDirectory, filename.toString());
    }
}

