/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.events;

import com.github.dozermapper.core.MappingException;
import com.github.dozermapper.core.events.Event;
import com.github.dozermapper.core.events.EventListener;
import com.github.dozermapper.core.events.EventManager;
import java.util.List;

public final class DefaultEventManager
implements EventManager {
    private final List<? extends EventListener> eventListeners;

    public DefaultEventManager(List<? extends EventListener> eventListeners) {
        this.eventListeners = eventListeners;
    }

    @Override
    public void on(Event event) {
        if (this.eventListeners != null) {
            block6: for (EventListener eventListener : this.eventListeners) {
                switch (event.getType()) {
                    case MAPPING_STARTED: {
                        eventListener.onMappingStarted(event);
                        continue block6;
                    }
                    case MAPPING_PRE_WRITING_DEST_VALUE: {
                        eventListener.onPreWritingDestinationValue(event);
                        continue block6;
                    }
                    case MAPPING_POST_WRITING_DEST_VALUE: {
                        eventListener.onPostWritingDestinationValue(event);
                        continue block6;
                    }
                    case MAPPING_FINISHED: {
                        eventListener.onMappingFinished(event);
                        continue block6;
                    }
                }
                throw new MappingException("Unsupported event type: " + event.getType());
            }
        }
    }
}

