/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.builder.model.jaxb;

import com.github.dozermapper.core.builder.model.jaxb.ConfigurationDefinition;
import com.github.dozermapper.core.config.BeanContainer;
import com.github.dozermapper.core.util.MappingUtils;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="")
@XmlRootElement(name="allowed-exceptions")
public class AllowedExceptionsDefinition {
    @XmlTransient
    private final ConfigurationDefinition parent;
    @XmlElement(name="exception", required=true)
    protected List<String> exceptions;

    public AllowedExceptionsDefinition() {
        this(null);
    }

    public AllowedExceptionsDefinition(ConfigurationDefinition parent) {
        this.parent = parent;
    }

    public AllowedExceptionsDefinition addException(String exception) {
        if (this.getExceptions() == null) {
            this.setExceptions(new ArrayList<String>());
        }
        this.getExceptions().add(exception);
        return this;
    }

    public List<Class<RuntimeException>> build(BeanContainer beanContainer) {
        ArrayList<Class<RuntimeException>> answer = new ArrayList<Class<RuntimeException>>();
        for (String current : this.exceptions) {
            Class<?> runtimeException = MappingUtils.loadClass(current, beanContainer);
            if (!RuntimeException.class.isAssignableFrom(runtimeException)) {
                MappingUtils.throwMappingException("allowed-exceptions must extend java.lang.RuntimeException. Found: " + runtimeException.getName());
            }
            answer.add(runtimeException);
        }
        return answer;
    }

    public ConfigurationDefinition end() {
        return this.parent;
    }

    public ConfigurationDefinition getParent() {
        return this.parent;
    }

    public List<String> getExceptions() {
        return this.exceptions;
    }

    protected void setExceptions(List<String> exceptions) {
        this.exceptions = exceptions;
    }

    public String toString() {
        return "AllowedExceptionsDefinition(parent=" + this.getParent() + ", exceptions=" + this.getExceptions() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AllowedExceptionsDefinition)) {
            return false;
        }
        AllowedExceptionsDefinition other = (AllowedExceptionsDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ConfigurationDefinition this$parent = this.getParent();
        ConfigurationDefinition other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
            return false;
        }
        List<String> this$exceptions = this.getExceptions();
        List<String> other$exceptions = other.getExceptions();
        return !(this$exceptions == null ? other$exceptions != null : !((Object)this$exceptions).equals(other$exceptions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AllowedExceptionsDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConfigurationDefinition $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
        List<String> $exceptions = this.getExceptions();
        result = result * 59 + ($exceptions == null ? 43 : ((Object)$exceptions).hashCode());
        return result;
    }
}

