/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.loader;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.dozer.CustomConverter;
import org.dozer.classmap.ClassMap;
import org.dozer.classmap.ClassMapBuilder;
import org.dozer.classmap.ClassMappings;
import org.dozer.classmap.Configuration;
import org.dozer.classmap.MappingFileData;
import org.dozer.converters.CustomConverterContainer;
import org.dozer.converters.CustomConverterDescription;
import org.dozer.loader.LoadMappingsResult;
import org.dozer.loader.MappingsParser;
import org.dozer.util.MappingUtils;

public class CustomMappingsLoader {
    private static final MappingsParser mappingsParser = MappingsParser.getInstance();

    public LoadMappingsResult load(List<MappingFileData> mappings) {
        Configuration globalConfiguration = this.findConfiguration(mappings);
        ClassMappings customMappings = new ClassMappings();
        for (MappingFileData mappingFileData : mappings) {
            List<ClassMap> list = mappingFileData.getClassMaps();
            ClassMappings customMappingsPrime = mappingsParser.processMappings(list, globalConfiguration);
            customMappings.addAll(customMappingsPrime);
        }
        ClassMapBuilder.addDefaultFieldMappings(customMappings, globalConfiguration);
        LinkedHashSet<CustomConverterDescription> customConverterDescriptions = new LinkedHashSet<CustomConverterDescription>();
        if (globalConfiguration.getCustomConverters() != null && globalConfiguration.getCustomConverters().getConverters() != null) {
            for (CustomConverterDescription customConverterDescription : globalConfiguration.getCustomConverters().getConverters()) {
                customConverterDescriptions.add(customConverterDescription);
            }
        }
        for (Map.Entry entry : customMappings.getAll().entrySet()) {
            ClassMap classMap = (ClassMap)entry.getValue();
            if (classMap.getCustomConverters() != null) {
                classMap.getCustomConverters().setConverters(new ArrayList<CustomConverterDescription>(customConverterDescriptions));
                continue;
            }
            classMap.setCustomConverters(new CustomConverterContainer());
            classMap.getCustomConverters().setConverters(new ArrayList<CustomConverterDescription>(customConverterDescriptions));
        }
        this.addDefaultCustomConverters(globalConfiguration);
        return new LoadMappingsResult(customMappings, globalConfiguration);
    }

    private Configuration findConfiguration(List<MappingFileData> mappingFileDataList) {
        Configuration globalConfiguration = null;
        for (MappingFileData mappingFileData : mappingFileDataList) {
            if (mappingFileData.getConfiguration() == null) continue;
            if (globalConfiguration != null) {
                MappingUtils.throwMappingException("More than one global configuration found.  Only one global configuration block (<configuration></configuration>) can be specified across all mapping files.  You need to consolidate all global configuration blocks into a single one.");
            }
            globalConfiguration = mappingFileData.getConfiguration();
        }
        if (globalConfiguration == null) {
            globalConfiguration = new Configuration();
        }
        return globalConfiguration;
    }

    private void addDefaultCustomConverters(Configuration globalConfiguration) {
        if (globalConfiguration.getCustomConverters() != null && globalConfiguration.getCustomConverters().findConverter(UUID.class, UUID.class) == null) {
            CustomConverterDescription defaultUUIDConverter = new CustomConverterDescription();
            defaultUUIDConverter.setClassA(UUID.class);
            defaultUUIDConverter.setClassB(UUID.class);
            defaultUUIDConverter.setType(ByReferenceConverter.class);
            globalConfiguration.getCustomConverters().addConverter(defaultUUIDConverter);
        }
    }

    public static class ByReferenceConverter
    implements CustomConverter {
        @Override
        public Object convert(Object existingDestinationFieldValue, Object sourceFieldValue, Class<?> destinationClass, Class<?> sourceClass) {
            return sourceFieldValue;
        }
    }
}

