/*
 * Decompiled with CFR 0.152.
 */
package com.github.downgoon.jresty.data.orm.dao.util;

import com.github.downgoon.jresty.data.orm.dao.util.PojoOperator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class PojoReflectionCached
implements PojoOperator {
    private PojoOperator delegateOperator;
    private InnerCache attriValueCache = new MemInnerCache();
    private DualLock attriValueLock = new DualLock();
    private InnerCache attriTypeCache = new MemInnerCache();

    public PojoReflectionCached(PojoOperator delegateOperator) {
        this.delegateOperator = delegateOperator;
    }

    @Override
    public Object newInstance(Class<?> pojoClass) {
        return this.delegateOperator.newInstance(pojoClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object doGetter(Object pojoBean, String attriName) {
        Object cachedValue = this.attriValueCache.get(pojoBean, attriName);
        if (cachedValue == null) {
            cachedValue = this.delegateOperator.doGetter(pojoBean, attriName);
            this.attriValueLock.getLock(pojoBean, attriName).writeLock().lock();
            try {
                this.attriValueCache.put(pojoBean, attriName, cachedValue);
            }
            finally {
                this.attriValueLock.getLock(pojoBean, attriName).writeLock().unlock();
            }
        }
        return cachedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doSetter(Object pojoBean, String attriName, Object attriValue) {
        this.attriValueLock.getLock(pojoBean, attriName).writeLock().lock();
        try {
            this.delegateOperator.doSetter(pojoBean, attriName, attriValue);
            this.attriValueCache.put(pojoBean, attriName, attriValue);
        }
        finally {
            this.attriValueLock.getLock(pojoBean, attriName).writeLock().unlock();
        }
    }

    @Override
    public Class<?> attriType(Class<?> pojoClass, String attriName) {
        Class<?> cachedType = (Class<?>)this.attriTypeCache.get(pojoClass, attriName);
        if (cachedType == null) {
            cachedType = this.delegateOperator.attriType(pojoClass, attriName);
            this.attriTypeCache.put(pojoClass, attriName, cachedType);
        }
        return cachedType;
    }

    private static class DualLock {
        private ConcurrentHashMap<Object, ConcurrentHashMap<String, ReadWriteLock>> dualLockMap = new ConcurrentHashMap();

        private DualLock() {
        }

        public ReadWriteLock getLock(Object groupKey, String subKey) {
            ConcurrentHashMap<String, ReadWriteLock> group = this.getGroup(groupKey);
            ReadWriteLock lockFound = group.get(subKey);
            if (lockFound != null) {
                return lockFound;
            }
            ReentrantReadWriteLock lockCreate = new ReentrantReadWriteLock();
            ReadWriteLock lockExisted = group.putIfAbsent(subKey, lockCreate);
            if (lockExisted != null) {
                return lockExisted;
            }
            return lockCreate;
        }

        private ConcurrentHashMap<String, ReadWriteLock> getGroup(Object groupKey) {
            ConcurrentHashMap<String, ReadWriteLock> groupFound = this.dualLockMap.get(groupKey);
            if (groupFound != null) {
                return groupFound;
            }
            ConcurrentHashMap<String, ReadWriteLock> groupCreate = new ConcurrentHashMap<String, ReadWriteLock>();
            ConcurrentHashMap<String, ReadWriteLock> groupExisted = this.dualLockMap.putIfAbsent(groupKey, groupCreate);
            if (groupExisted != null) {
                return groupExisted;
            }
            return groupCreate;
        }
    }

    private static class MemInnerCache
    implements InnerCache {
        private ConcurrentHashMap<Object, ConcurrentHashMap<String, Object>> dualMap = new ConcurrentHashMap();

        private MemInnerCache() {
        }

        @Override
        public Object get(Object groupKey, String subKey) {
            ConcurrentHashMap<String, Object> group = this.getGroup(groupKey);
            return group.get(subKey);
        }

        @Override
        public Object put(Object groupKey, String subKey, Object value) {
            ConcurrentHashMap<String, Object> group = this.getGroup(groupKey);
            if (value == null) {
                return group.remove(subKey);
            }
            return group.put(subKey, value);
        }

        private ConcurrentHashMap<String, Object> getGroup(Object groupKey) {
            ConcurrentHashMap<String, Object> groupFound = this.dualMap.get(groupKey);
            if (groupFound != null) {
                return groupFound;
            }
            ConcurrentHashMap<String, Object> groupCreate = new ConcurrentHashMap<String, Object>();
            ConcurrentHashMap<String, Object> groupExisted = this.dualMap.putIfAbsent(groupKey, groupCreate);
            if (groupExisted != null) {
                return groupExisted;
            }
            return groupCreate;
        }
    }

    static interface InnerCache {
        public Object get(Object var1, String var2);

        public Object put(Object var1, String var2, Object var3);
    }
}

