/*
 * Decompiled with CFR 0.152.
 */
package com.github.downgoon.jresty.data.orm.dao.util;

import com.github.downgoon.jresty.data.orm.dao.util.PojoOperator;
import java.lang.reflect.Method;

public class PojoReflection
implements PojoOperator {
    @Override
    public Object newInstance(Class<?> pojoClass) {
        try {
            return pojoClass.newInstance();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object doGetter(Object pojoBean, String attriName) {
        try {
            Method method = PojoReflection.methodGetter(pojoBean.getClass(), attriName);
            return method.invoke(pojoBean, new Object[0]);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void doSetter(Object pojoBean, String attriName, Object attriValue) {
        try {
            Class<?> attriType = this.attriType(pojoBean.getClass(), attriName);
            Method method = PojoReflection.methodSetter(pojoBean.getClass(), attriName, attriType);
            method.invoke(pojoBean, attriValue);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Class<?> attriType(Class<?> pojoClass, String attriName) {
        try {
            Method method = PojoReflection.methodGetter(pojoClass, attriName);
            return method.getReturnType();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Method methodGetter(Class<?> pojoClass, String attriName) throws SecurityException, NoSuchMethodException {
        Method method = null;
        NoSuchMethodException noSuchMethodException = null;
        try {
            method = pojoClass.getMethod(PojoReflection.assembMethodName("get", attriName), new Class[0]);
        }
        catch (NoSuchMethodException nsme) {
            noSuchMethodException = nsme;
        }
        if (method != null) {
            return method;
        }
        method = pojoClass.getMethod(PojoReflection.assembMethodName("is", attriName), new Class[0]);
        if (method != null && Boolean.class.equals(method.getReturnType())) {
            return method;
        }
        throw noSuchMethodException;
    }

    private static Method methodSetter(Class<?> pojoClass, String attriName, Class<?> attriType) throws SecurityException, NoSuchMethodException {
        return pojoClass.getMethod(PojoReflection.assembMethodName("set", attriName), attriType);
    }

    private static String assembMethodName(String prefix, String attriName) {
        if (attriName.length() <= 1) {
            return prefix + attriName.toUpperCase();
        }
        return prefix + attriName.substring(0, 1).toUpperCase() + attriName.substring(1);
    }
}

