/*
 * Decompiled with CFR 0.152.
 */
package com.github.downgoon.jresty.data.orm.dao.sql;

import com.github.downgoon.jresty.data.orm.dao.sql.ORMBuilderFacade;
import com.github.downgoon.jresty.data.orm.dao.sql.ORValueMapping;
import com.github.downgoon.jresty.data.orm.dao.sql.SQLWrapper;
import java.util.Iterator;
import java.util.Map;

public class Where {
    private String dbTableName;
    private Map<String, Object> dbKeys;
    private Map<String, Object> dbFields;

    public Where(Object objectBean) {
        ORMBuilderFacade ormBuilderFacade = new ORMBuilderFacade(objectBean);
        ORValueMapping valueMapping = ormBuilderFacade.buildValueMapping();
        this.dbTableName = valueMapping.getDbTalbeName();
        this.dbKeys = valueMapping.getDbKeysKV();
        this.dbFields = valueMapping.getDbFieldKV();
    }

    protected Where(String dbTableName, Map<String, Object> dbKeys, Map<String, Object> dbFields) {
        this.dbTableName = dbTableName;
        this.dbKeys = dbKeys;
        this.dbFields = dbFields;
    }

    protected String toSelectSQL(String selectFieldList) {
        StringBuffer sqlBeforeWhere = new StringBuffer("SELECT " + selectFieldList + " FROM ");
        sqlBeforeWhere.append(SQLWrapper.wrapTableName(this.dbTableName));
        String whereCause = this.toWhereSQL();
        if (whereCause.length() > 0) {
            sqlBeforeWhere.append(" WHERE ").append(whereCause);
        } else {
            sqlBeforeWhere.append(whereCause);
        }
        return sqlBeforeWhere.toString();
    }

    public String toSelectSQL() {
        return this.toSelectSQL("*");
    }

    public String toWhereSQL() {
        return this.toWhereSQL(null);
    }

    public String toWhereSQL(String tableAlias) {
        StringBuffer sqlBeforeWhere = new StringBuffer();
        StringBuffer sqlKeysCondi = new StringBuffer();
        int keysAdded = Where.genSQLEachField(tableAlias, this.dbKeys, " and ", sqlKeysCondi, "=", sqlKeysCondi);
        StringBuffer sqlFieldsCondi = new StringBuffer();
        int fieldsAdded = Where.genSQLEachField(tableAlias, this.dbFields, " and ", sqlFieldsCondi, "=", sqlFieldsCondi);
        if (keysAdded > 0 && sqlKeysCondi.length() > 0) {
            sqlBeforeWhere.append(sqlKeysCondi);
        }
        if (keysAdded > 0 && fieldsAdded > 0) {
            sqlBeforeWhere.append(" and ");
        }
        if (fieldsAdded > 0 && sqlFieldsCondi.length() > 0) {
            sqlBeforeWhere.append(sqlFieldsCondi);
        }
        return sqlBeforeWhere.toString();
    }

    private static int genSQLEachField(String tableAlias, Map<String, Object> dbFields, String catFields, StringBuffer sqlFieldName, String catNameValue, StringBuffer sqlFieldValue) {
        int fieldCntAppended = 0;
        Iterator<Map.Entry<String, Object>> kvs = dbFields.entrySet().iterator();
        boolean isDivNeed = false;
        while (kvs.hasNext()) {
            Map.Entry<String, Object> e = kvs.next();
            if (e.getValue() == null) continue;
            if (isDivNeed) {
                sqlFieldName.append(catFields);
                if (sqlFieldName != sqlFieldValue) {
                    sqlFieldValue.append(catFields);
                }
            }
            if (tableAlias != null) {
                sqlFieldName.append(tableAlias).append(".");
            }
            sqlFieldName.append("`").append(e.getKey()).append("`");
            if (catNameValue != null) {
                sqlFieldName.append(catNameValue);
            }
            sqlFieldValue.append(SQLWrapper.wrapDbFieldValue(e.getValue()));
            ++fieldCntAppended;
            isDivNeed = true;
        }
        return fieldCntAppended;
    }
}

