/*
 * Decompiled with CFR 0.152.
 */
package com.github.downgoon.jresty.data.orm.dao.sql;

import com.github.downgoon.jresty.data.orm.dao.sql.HQL;
import com.github.downgoon.jresty.data.orm.dao.sql.ORFieldMapping;
import com.github.downgoon.jresty.data.orm.dao.sql.ORMBuilderFacade;
import com.github.downgoon.jresty.data.orm.dao.sql.ORValueMapping;
import com.github.downgoon.jresty.data.orm.dao.sql.SQLWrapper;
import com.github.downgoon.jresty.data.orm.dao.sql.Where;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

public class SQLGenerator {
    private static final int SQL_TYPE_UPDATE = 1;
    private static final int SQL_TYPE_INSERT = 2;
    private static final int SQL_TYPE_SELECT = 3;
    private static final int SQL_TYPE_DELETE = 4;

    public String genSQLUpdate(Object objectBean) {
        return this.genSQL(objectBean, 1);
    }

    public String genSQLUpdate(Object objectBean, String ... whereCondiFields) {
        ORMBuilderFacade ormBuilderFacade = new ORMBuilderFacade(objectBean);
        ORFieldMapping fieldMapping = ormBuilderFacade.buildFieldMapping();
        ORValueMapping valueMapping = ormBuilderFacade.buildValueMapping();
        LinkedHashMap<String, Object> whereCondi = new LinkedHashMap<String, Object>();
        String[] dbColumNames = new String[whereCondiFields.length];
        for (int i = 0; i < whereCondiFields.length; ++i) {
            if (fieldMapping.getDb2Java().containsKey(whereCondiFields[i])) {
                dbColumNames[i] = whereCondiFields[i];
            } else if (fieldMapping.getJava2Db().containsKey(whereCondiFields[i])) {
                dbColumNames[i] = fieldMapping.getJava2Db().get(whereCondiFields[i]);
            } else {
                throw new IllegalArgumentException("unrecognized field name: " + whereCondiFields[i]);
            }
            if (fieldMapping.isKey(dbColumNames[i])) {
                whereCondi.put(dbColumNames[i], valueMapping.getDbFieldKV().get(dbColumNames[i]));
            } else {
                whereCondi.put(dbColumNames[i], valueMapping.getDbFieldKV().get(dbColumNames[i]));
                valueMapping.getDbFieldKV().remove(dbColumNames[i]);
            }
            if (whereCondi.get(dbColumNames[i]) != null) continue;
            throw new IllegalArgumentException("NULL field value for: " + whereCondiFields[i]);
        }
        return SQLGenerator.genSQLUpdate(fieldMapping.getDbTableName(), whereCondi, valueMapping.getDbFieldKV());
    }

    public String genSQLInsert(Object objectBean) {
        return this.genSQL(objectBean, 2);
    }

    public String genSQLSelect(Object objectBean) {
        return this.genSQL(objectBean, 3);
    }

    public String genSQLSelect(Object objectBean, HQL ... hqls) {
        ORMBuilderFacade ormBuilderFacade = new ORMBuilderFacade(objectBean);
        ORFieldMapping fieldMapping = ormBuilderFacade.buildFieldMapping();
        ORValueMapping valueMapping = ormBuilderFacade.buildValueMapping();
        TreeMap<Integer, HQL> hqlMap = new TreeMap<Integer, HQL>();
        for (HQL hql : hqls) {
            if (hqlMap.containsKey(hql.getIndex())) {
                throw new IllegalArgumentException("duplicated HQL type: " + hql.getClass().getSimpleName());
            }
            hqlMap.put(hql.getIndex(), hql);
        }
        StringBuffer sql = new StringBuffer();
        HQL selectHQL = (HQL)hqlMap.get(10);
        if (selectHQL != null) {
            sql.append(SQLGenerator.genSQLSelect(selectHQL.genSQL(fieldMapping.getJava2Db(), fieldMapping.getDb2Java()), fieldMapping.getDbTableName(), valueMapping.getDbKeysKV(), valueMapping.getDbFieldKV()));
        } else {
            sql.append(SQLGenerator.genSQLSelect("*", fieldMapping.getDbTableName(), valueMapping.getDbKeysKV(), valueMapping.getDbFieldKV()));
        }
        Iterator hqlIter = hqlMap.entrySet().iterator();
        while (hqlIter.hasNext()) {
            HQL hql;
            hql = (HQL)hqlIter.next().getValue();
            if (hql.getIndex() <= 10) continue;
            sql.append(hql.genSQL(fieldMapping.getJava2Db(), fieldMapping.getDb2Java()));
        }
        return sql.toString();
    }

    protected String genSQL(Object objectBean, int sqlType) {
        ORMBuilderFacade ormBuilderFacade = new ORMBuilderFacade(objectBean);
        ORFieldMapping fieldMapping = ormBuilderFacade.buildFieldMapping();
        ORValueMapping valueMapping = ormBuilderFacade.buildValueMapping();
        String sql = null;
        switch (sqlType) {
            case 1: {
                sql = SQLGenerator.genSQLUpdate(fieldMapping.getDbTableName(), valueMapping.getDbKeysKV(), valueMapping.getDbFieldKV());
                break;
            }
            case 2: {
                sql = SQLGenerator.genSQLInsert(fieldMapping.getDbTableName(), valueMapping.getDbKeysKV(), valueMapping.getDbFieldKV());
                break;
            }
            case 3: {
                sql = SQLGenerator.genSQLSelect(fieldMapping.getDbTableName(), valueMapping.getDbKeysKV(), valueMapping.getDbFieldKV());
                break;
            }
            case 4: {
                sql = SQLGenerator.genSQLDelete(fieldMapping.getDbTableName(), valueMapping.getDbKeysKV(), valueMapping.getDbFieldKV());
                break;
            }
            default: {
                throw new IllegalArgumentException("not supported action: " + sqlType);
            }
        }
        return sql;
    }

    public static String genSQLUpdate(String dbTableName, Map<String, Object> dbKeyes, Map<String, Object> dbFields) {
        StringBuffer sqlUpdate = new StringBuffer("UPDATE ");
        sqlUpdate.append(SQLWrapper.wrapTableName(dbTableName)).append(" SET ");
        int fieldAdded = SQLGenerator.genSQLEachField(dbFields, ",", sqlUpdate, "=", sqlUpdate);
        sqlUpdate.append(" where ");
        int keysAdded = SQLGenerator.genSQLEachField(dbKeyes, " and ", sqlUpdate, "=", sqlUpdate);
        if (fieldAdded <= 0 || keysAdded <= 0) {
            throw new IllegalArgumentException("update statement can't be generated: " + sqlUpdate.toString());
        }
        return sqlUpdate.toString();
    }

    public static String genSQLInsert(String dbTableName, Map<String, Object> dbKeys, Map<String, Object> dbFields) {
        StringBuffer sqlInsertKeys = new StringBuffer("INSERT INTO ");
        sqlInsertKeys.append(SQLWrapper.wrapTableName(dbTableName)).append("( ");
        StringBuffer sqlValueKeys = new StringBuffer("VALUES (");
        int keysAdded = SQLGenerator.genSQLEachField(dbKeys, ",", sqlInsertKeys, null, sqlValueKeys);
        StringBuffer sqlInsertFields = new StringBuffer();
        StringBuffer sqlValueFields = new StringBuffer();
        int fieldsAdded = SQLGenerator.genSQLEachField(dbFields, ",", sqlInsertFields, null, sqlValueFields);
        if (keysAdded > 0 && fieldsAdded > 0) {
            sqlInsertKeys.append(",");
            sqlValueKeys.append(",");
        }
        sqlInsertFields.append(") ");
        sqlValueFields.append(")");
        return sqlInsertKeys.toString() + sqlInsertFields.toString() + sqlValueKeys.toString() + sqlValueFields.toString();
    }

    public static String genSQLSelect(String dbTableName, Map<String, Object> dbKeys, Map<String, Object> dbFields) {
        return new Where(dbTableName, dbKeys, dbFields).toSelectSQL();
    }

    private static String genSQLSelect(String selectFieldList, String dbTableName, Map<String, Object> dbKeys, Map<String, Object> dbFields) {
        return new Where(dbTableName, dbKeys, dbFields).toSelectSQL(selectFieldList);
    }

    public String genSQLDelete(Object objectBean) {
        return this.genSQL(objectBean, 4);
    }

    protected static String genSQLDelete(String dbTableName, Map<String, Object> dbKeys, Map<String, Object> dbFields) {
        StringBuffer sqlDelete = new StringBuffer("DELETE FROM ");
        sqlDelete.append(SQLWrapper.wrapTableName(dbTableName));
        String dynamicWhere = new Where(dbTableName, dbKeys, dbFields).toWhereSQL();
        if (dynamicWhere != null && dynamicWhere.length() > 0) {
            sqlDelete.append(" WHERE ").append(dynamicWhere);
        }
        return sqlDelete.toString();
    }

    private static int genSQLEachField(Map<String, Object> dbFields, String catFields, StringBuffer sqlFieldName, String catNameValue, StringBuffer sqlFieldValue) {
        int fieldCntAppended = 0;
        Iterator<Map.Entry<String, Object>> kvs = dbFields.entrySet().iterator();
        boolean isDivNeed = false;
        while (kvs.hasNext()) {
            Map.Entry<String, Object> e = kvs.next();
            if (e.getValue() == null) continue;
            if (isDivNeed) {
                sqlFieldName.append(catFields);
                if (sqlFieldName != sqlFieldValue) {
                    sqlFieldValue.append(catFields);
                }
            }
            sqlFieldName.append("`").append(e.getKey()).append("`");
            if (catNameValue != null) {
                sqlFieldName.append(catNameValue);
            }
            sqlFieldValue.append(SQLWrapper.wrapDbFieldValue(e.getValue()));
            ++fieldCntAppended;
            isDivNeed = true;
        }
        return fieldCntAppended;
    }
}

