/*
 * Decompiled with CFR 0.152.
 */
package com.github.downgoon.jresty.data.orm.dao.sql;

import com.github.downgoon.jresty.data.orm.dao.sql.ORFieldMapping;
import com.github.downgoon.jresty.data.orm.dao.sql.ORValueMapping;
import com.github.downgoon.jresty.data.orm.dao.util.PojoOperatorFactory;
import java.util.LinkedHashMap;
import java.util.Map;

class ORValueMappingBuilder {
    private Object pojoBean;
    private ORFieldMapping fieldMapping;

    public ORValueMappingBuilder(Object pojoBean, ORFieldMapping fieldMapping) {
        this.pojoBean = pojoBean;
        this.fieldMapping = fieldMapping;
    }

    public ORValueMapping buildValueMapping() {
        LinkedHashMap<String, Object> dbKeysKV = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> dbFieldKV = new LinkedHashMap<String, Object>();
        String dbTableName = this.dumpColumValue(dbKeysKV, dbFieldKV);
        return new ORValueMapping(dbTableName, dbKeysKV, dbFieldKV);
    }

    private String dumpColumValue(Map<String, Object> dbKeysKV, Map<String, Object> dbFieldKV) {
        for (Map.Entry<String, String> field : this.fieldMapping.getJava2Db().entrySet()) {
            String javaAttriName = field.getKey();
            String dbColumName = field.getValue();
            Object javaAttriValue = PojoOperatorFactory.getPojoOperator().doGetter(this.pojoBean, javaAttriName);
            if (javaAttriName == null) continue;
            if (this.fieldMapping.isKey(dbColumName)) {
                dbKeysKV.put(dbColumName, javaAttriValue);
                continue;
            }
            dbFieldKV.put(dbColumName, javaAttriValue);
        }
        return this.fieldMapping.getDbTableName();
    }
}

