/*
 * Decompiled with CFR 0.152.
 */
package com.github.downgoon.jresty.data.orm.dao.sql;

import com.github.downgoon.jresty.data.orm.dao.sql.ORFieldMapping;
import com.github.downgoon.jresty.data.orm.dao.sql.ORFieldMappingBuilder;
import com.github.downgoon.jresty.data.orm.dao.util.PojoOperatorFactory;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.springframework.jdbc.core.RowMapper;

public class ORMRowMapper<T>
implements RowMapper<T> {
    private final boolean isCompleteMapping;
    private final Class<?> pojoClass;
    private ORFieldMapping fieldMapping;

    public ORMRowMapper(Class<?> pojoClass) {
        this(pojoClass, false);
    }

    public ORMRowMapper(Class<?> pojoClass, boolean isCompleteMapping) {
        this(pojoClass, isCompleteMapping, false);
    }

    public ORMRowMapper(Class<?> pojoClass, boolean isCompleteMapping, boolean isOnlyForSelect) {
        this.pojoClass = pojoClass;
        this.isCompleteMapping = isCompleteMapping;
        ORFieldMappingBuilder fieldBuilder = new ORFieldMappingBuilder(pojoClass, isOnlyForSelect);
        this.fieldMapping = fieldBuilder.buildFieldMapping();
    }

    public T mapRow(ResultSet rs, int rowNum) throws SQLException {
        Object newBean = PojoOperatorFactory.getPojoOperator().newInstance(this.pojoClass);
        int columns = rs.getMetaData().getColumnCount();
        for (int cidx = 1; cidx <= columns; ++cidx) {
            String columName = rs.getMetaData().getColumnName(cidx);
            String attriName = this.fieldMapping.getDb2Java().get(columName);
            if (attriName == null) {
                columName = columName.toLowerCase();
                attriName = this.fieldMapping.getDb2Java().get(columName);
            }
            if (attriName == null) {
                if (!this.isCompleteMapping) continue;
                throw new IllegalStateException("No POJO attribute mapping found for db tablecolumn  '" + columName + "'");
            }
            Class<?> attriType = this.fieldMapping.getDbFieldJavaType().get(columName);
            if (rs.getObject(cidx) == null) continue;
            Object columValue = this.convertFieldType(rs, cidx, attriType);
            Object attriValue = this.convertFieldValue(columValue);
            PojoOperatorFactory.getPojoOperator().doSetter(newBean, attriName, attriValue);
        }
        return (T)newBean;
    }

    private Object convertFieldType(ResultSet rs, int columnIndex, Class<?> attriType) throws SQLException {
        if (Integer.class.equals(attriType)) {
            return rs.getInt(columnIndex);
        }
        if (String.class.equals(attriType)) {
            return rs.getString(columnIndex);
        }
        if (Long.class.equals(attriType)) {
            return rs.getLong(columnIndex);
        }
        if (Double.class.equals(attriType)) {
            return rs.getDouble(columnIndex);
        }
        if (Short.class.equals(attriType)) {
            return rs.getShort(columnIndex);
        }
        if (Boolean.class.equals(attriType)) {
            return rs.getBoolean(columnIndex);
        }
        if (Date.class.equals(attriType)) {
            return new Date(rs.getTimestamp(columnIndex).getTime());
        }
        return rs.getObject(columnIndex);
    }

    protected Object convertFieldValue(Object dbColumValue) {
        if (dbColumValue instanceof java.sql.Date) {
            return new Date(((java.sql.Date)dbColumValue).getTime());
        }
        return dbColumValue;
    }
}

