/*
 * Decompiled with CFR 0.152.
 */
package com.github.downgoon.jresty.data.orm.dao.sql;

import com.github.downgoon.jresty.data.orm.annotation.ORMField;
import com.github.downgoon.jresty.data.orm.annotation.ORMTable;
import com.github.downgoon.jresty.data.orm.dao.sql.ORFieldMapping;
import com.github.downgoon.jresty.data.orm.dao.util.PojoOperatorFactory;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.Map;

class ORFieldMappingBuilder {
    private boolean isOnlyForSelect = false;
    private Class<?> pojoClass;

    public ORFieldMappingBuilder(Class<?> pojoClass) {
        this(pojoClass, false);
    }

    public ORFieldMappingBuilder(Class<?> pojoClass, boolean isOnlyForSelect) {
        this.pojoClass = pojoClass;
        this.isOnlyForSelect = isOnlyForSelect;
    }

    public ORFieldMapping buildFieldMapping() {
        LinkedHashMap<String, String> java2db = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> db2java = new LinkedHashMap<String, String>();
        LinkedHashMap<String, Boolean> dbKeys = new LinkedHashMap<String, Boolean>();
        LinkedHashMap dbFieldJavaType = new LinkedHashMap();
        StringBuffer autoIncrColum = new StringBuffer();
        String dbTableName = this.dumpFieldMapping(java2db, db2java, dbKeys, dbFieldJavaType, autoIncrColum);
        ORFieldMapping fm = new ORFieldMapping(dbTableName, java2db, db2java, dbKeys, dbFieldJavaType, autoIncrColum.toString());
        return fm;
    }

    protected String dumpFieldMapping(Map<String, String> java2db, Map<String, String> db2java, Map<String, Boolean> dbKeys, Map<String, Class<?>> dbFieldJavaType, StringBuffer autoIncrColum) {
        Method[] methods;
        String dbTableName = null;
        ORMTable tableAnnotation = this.pojoClass.getAnnotation(ORMTable.class);
        dbTableName = tableAnnotation != null ? tableAnnotation.name() : this.pojoClass.getSimpleName().toLowerCase();
        for (Method method : methods = this.pojoClass.getDeclaredMethods()) {
            boolean isAutoIncr;
            ORMField fieldAnnotation;
            boolean isSkip;
            String objAttriName;
            int mod = method.getModifiers();
            if (!Modifier.isPublic(mod) || Modifier.isStatic(mod) || (objAttriName = ORFieldMappingBuilder.isPojoGetter(method)) == null || (isSkip = ORFieldMappingBuilder.isSkipField(objAttriName, fieldAnnotation = method.getAnnotation(ORMField.class)))) continue;
            String dbFieldName = ORFieldMappingBuilder.attri2ColumName(objAttriName, fieldAnnotation);
            java2db.put(objAttriName, dbFieldName);
            db2java.put(dbFieldName, objAttriName);
            boolean isKey = ORFieldMappingBuilder.isKeyField(dbTableName, objAttriName, fieldAnnotation);
            if (dbKeys != null && isKey) {
                dbKeys.put(dbFieldName, true);
            }
            boolean bl = isAutoIncr = fieldAnnotation != null && fieldAnnotation.isAutoIncrement();
            if (isAutoIncr) {
                if (!isKey) {
                    throw new IllegalArgumentException(String.format("key required for AUTO_INCREMENT setting: %s.%s", this.pojoClass.getSimpleName(), objAttriName));
                }
                Class<?> objAttriType = PojoOperatorFactory.getPojoOperator().attriType(this.pojoClass, objAttriName);
                if (!this.isDigitalType(objAttriType)) {
                    throw new IllegalArgumentException(String.format("digital type required for AUTO_INCREMENT setting: %s.%s", this.pojoClass.getSimpleName(), objAttriName));
                }
                if (autoIncrColum.length() > 0) {
                    throw new IllegalArgumentException(String.format("too many AUTO_INCREMENT setting: %s.%s and %s.%s", this.pojoClass.getSimpleName(), objAttriName, this.pojoClass.getSimpleName(), autoIncrColum));
                }
                autoIncrColum.append(dbFieldName);
            }
            if (dbFieldJavaType == null) continue;
            dbFieldJavaType.put(dbFieldName, PojoOperatorFactory.getPojoOperator().attriType(this.pojoClass, objAttriName));
        }
        if (!this.isOnlyForSelect) {
            if (dbKeys != null && dbKeys.size() <= 0) {
                throw new IllegalArgumentException("No keys found in the object bean named: " + this.pojoClass.getName());
            }
            if (db2java.size() <= 0) {
                throw new IllegalArgumentException("No fields found for update in the object bean named: " + this.pojoClass.getName());
            }
        }
        return dbTableName;
    }

    private boolean isDigitalType(Class<?> classType) {
        return Long.class.equals(classType) || Integer.class.equals(classType) || Short.class.equals(classType);
    }

    private static String isPojoGetter(Method method) {
        String attriName = null;
        String methodName = method.getName();
        if (methodName.startsWith("get") && !methodName.equals("getClass")) {
            attriName = methodName.substring("get".length());
        } else if (methodName.startsWith("is") && Boolean.class.equals(method.getReturnType())) {
            attriName = methodName.substring("is".length());
        }
        if (attriName == null || attriName.length() < 1) {
            return null;
        }
        Class<?>[] params = method.getParameterTypes();
        if (params != null && params.length > 0) {
            return null;
        }
        if (attriName.length() > 1) {
            return attriName.substring(0, 1).toLowerCase() + attriName.substring(1);
        }
        return attriName.toLowerCase();
    }

    private static boolean isSkipField(String objAttriName, ORMField fieldAnnotation) {
        return fieldAnnotation != null && fieldAnnotation.isSkip();
    }

    private static boolean isKeyField(String dbTableName, String objAttriName, ORMField fieldAnnotation) {
        if (fieldAnnotation == null) {
            if (objAttriName.startsWith("id")) {
                return true;
            }
            return objAttriName.toLowerCase().equals(dbTableName + "id");
        }
        return fieldAnnotation.isKey();
    }

    private static String attri2ColumName(String objAttriName, ORMField fieldAnnotation) {
        if (fieldAnnotation == null) {
            return objAttriName.toLowerCase();
        }
        return fieldAnnotation.name();
    }
}

