/*
 * Decompiled with CFR 0.152.
 */
package com.github.downgoon.jresty.data.orm.dao.sql;

import java.io.PrintWriter;
import java.util.Map;

public class ORFieldMapping {
    private Map<String, String> java2db;
    private String dbTableName;
    private Map<String, String> db2java;
    private Map<String, Boolean> dbKeys;
    private Map<String, Class<?>> dbFieldJavaType;
    private String autoIncrementColum;

    ORFieldMapping(String dbTableName, Map<String, String> java2db, Map<String, String> db2java, Map<String, Boolean> dbKeys, Map<String, Class<?>> dbFieldJavaType, String autoIncrementColum) {
        this.dbTableName = dbTableName;
        this.java2db = java2db;
        this.db2java = db2java;
        this.dbKeys = dbKeys;
        this.dbFieldJavaType = dbFieldJavaType;
        this.autoIncrementColum = autoIncrementColum == null || autoIncrementColum.length() == 0 ? null : autoIncrementColum;
    }

    public Map<String, Class<?>> getDbFieldJavaType() {
        return this.dbFieldJavaType;
    }

    public String getDbTableName() {
        return this.dbTableName;
    }

    public Map<String, String> getJava2Db() {
        return this.java2db;
    }

    public Map<String, String> getDb2Java() {
        return this.db2java;
    }

    public boolean isKey(String filedName) {
        String dbColumName;
        boolean isDbKey = this.isDBKey(filedName);
        if (!isDbKey && (dbColumName = this.java2db.get(filedName)) != null) {
            return this.isDBKey(dbColumName);
        }
        return isDbKey;
    }

    private boolean isDBKey(String dbColumName) {
        Boolean keyFlag = this.dbKeys.get(dbColumName);
        return keyFlag != null && keyFlag != false;
    }

    public boolean hasAutoIncrementKey() {
        return this.autoIncrementColum != null;
    }

    public String getAutoIncrementColum() {
        return this.autoIncrementColum;
    }

    public String getAutoIncrementAttri() {
        if (this.autoIncrementColum == null) {
            return null;
        }
        return this.db2java.get(this.autoIncrementColum);
    }

    public void print(PrintWriter writer) {
        writer.println(String.format("TableName: %s", this.dbTableName));
        writer.println(String.format("DB-Column\t|Java-Attri\t|Java-Type\t|isKey\t|isAuto", new Object[0]));
        writer.println("--------");
        for (Map.Entry<String, String> e : this.db2java.entrySet()) {
            String dbColumn = e.getKey();
            String javaAttri = e.getValue();
            String javaType = this.dbFieldJavaType.get(dbColumn).getSimpleName();
            Boolean isKey = this.dbKeys.containsKey(dbColumn);
            boolean isAutoIncr = isKey != false && this.autoIncrementColum != null && dbColumn.equals(this.autoIncrementColum);
            writer.println(String.format("%s\t|%s\t|%s\t|%s\t|%s", dbColumn, javaAttri, javaType, isKey != false ? "*" : "", isAutoIncr ? "*" : ""));
        }
        writer.println();
        writer.flush();
    }
}

