/*
 * Decompiled with CFR 0.152.
 */
package com.github.downgoon.jresty.data.orm.dao.sql;

import java.util.Map;

public abstract class HQL {
    public static final int INDEX_SELECT = 10;
    public static final int INDEX_ORDER = 20;
    public static final int INDEX_LIMIT = 30;

    public abstract int getIndex();

    public abstract String genSQL(Map<String, String> var1, Map<String, String> var2);

    protected String fieldMapping2DB(Map<String, String> java2db, Map<String, String> db2java, String[] fields, String[] padding) {
        StringBuffer sql = new StringBuffer();
        int cnt = 0;
        for (String fieldName : fields) {
            String columName = null;
            columName = db2java.containsKey(fieldName) ? fieldName : java2db.get(fieldName);
            if (columName == null) {
                throw new IllegalArgumentException("HQL field not found: " + fieldName);
            }
            if (cnt > 0) {
                sql.append(", ");
            }
            sql.append("`").append(columName).append("`");
            if (padding != null) {
                sql.append(padding[cnt]);
            }
            ++cnt;
        }
        return sql.toString();
    }

    public static HQL limit(int offset, int length) {
        return new Limit(offset, length);
    }

    public static HQL orderBy(String ... fields) {
        return new Order(fields);
    }

    public static HQL orderBy(String[] fields, boolean[] isDESC) {
        return new Order(fields, isDESC);
    }

    public static HQL select(String ... fields) {
        return new Select(fields);
    }

    public static class Limit
    extends HQL {
        private int offset;
        private int length;

        private Limit(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        @Override
        public String genSQL(Map<String, String> java2db, Map<String, String> db2java) {
            return String.format(" LIMIT %d,%d", this.offset, this.length);
        }

        @Override
        public int getIndex() {
            return 30;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }
    }

    public static class Order
    extends HQL {
        private String[] fields;
        private boolean[] isDESC;

        private Order(String[] fields, boolean[] isDESC) {
            this.fields = fields;
            this.isDESC = isDESC;
            if (fields.length != isDESC.length) {
                throw new IllegalArgumentException("orderby fields.length != isDESC.length");
            }
        }

        private Order(String ... fields) {
            this.fields = fields;
        }

        @Override
        public int getIndex() {
            return 20;
        }

        public String[] getFields() {
            return this.fields;
        }

        @Override
        public String genSQL(Map<String, String> java2db, Map<String, String> db2java) {
            StringBuilder sql = new StringBuilder(" ORDER BY ");
            String[] padding = null;
            if (this.isDESC != null) {
                padding = new String[this.isDESC.length];
                for (int i = 0; i < this.isDESC.length; ++i) {
                    padding[i] = this.isDESC[i] ? " DESC" : " ASC";
                }
            }
            sql.append(this.fieldMapping2DB(java2db, db2java, this.fields, padding));
            return sql.toString();
        }
    }

    public static class Select
    extends HQL {
        private String[] fields;

        private Select(String[] fields) {
            this.fields = fields;
        }

        @Override
        public int getIndex() {
            return 10;
        }

        @Override
        public String genSQL(Map<String, String> java2db, Map<String, String> db2java) {
            return this.fieldMapping2DB(java2db, db2java, this.fields, null);
        }
    }
}

