/*
 * Decompiled with CFR 0.152.
 */
package com.github.downgoon.jresty.data.orm.dao;

import com.github.downgoon.jresty.data.orm.dao.CRUDDao;
import com.github.downgoon.jresty.data.orm.dao.sql.HQL;
import com.github.downgoon.jresty.data.orm.dao.sql.ORFieldMapping;
import com.github.downgoon.jresty.data.orm.dao.sql.ORMBuilderFacade;
import com.github.downgoon.jresty.data.orm.dao.sql.ORMRowMapper;
import com.github.downgoon.jresty.data.orm.dao.sql.SQLGenerator;
import com.github.downgoon.jresty.data.orm.dao.util.PojoOperatorFactory;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.StatementCallback;
import org.springframework.jdbc.core.support.JdbcDaoSupport;

public class CRUDDaoSupport<T>
extends JdbcDaoSupport
implements CRUDDao<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CRUDDaoSupport.class);
    private SQLGenerator sqlGenerator = new SQLGenerator();

    @Override
    public int saveObject(final T t) {
        final String sqlInsert = this.sqlGenerator.genSQLInsert(t);
        LOGGER.debug("SQL: {}", (Object)sqlInsert);
        ORFieldMapping fieldMapping = new ORMBuilderFacade(t, false).buildFieldMapping();
        String autoIncrAttri = fieldMapping.getAutoIncrementAttri();
        if (autoIncrAttri == null || PojoOperatorFactory.getPojoOperator().doGetter(t, autoIncrAttri) != null) {
            return this.getJdbcTemplate().update(sqlInsert);
        }
        final AtomicInteger rowsAffect = new AtomicInteger();
        Long autoIncrValue = (Long)this.getJdbcTemplate().execute((StatementCallback)new StatementCallback<Long>(){

            public Long doInStatement(Statement stmt) throws SQLException, DataAccessException {
                int rows = stmt.executeUpdate(sqlInsert, 1);
                rowsAffect.set(rows);
                ResultSet rs = stmt.getGeneratedKeys();
                if (rs.next()) {
                    return rs.getLong(1);
                }
                throw new IllegalArgumentException(String.format("AUTO_INCREMENT not supported in Table %s", t.getClass().getSimpleName()));
            }
        });
        String autoIncrColum = fieldMapping.getAutoIncrementColum();
        Class<?> autoIncrType = fieldMapping.getDbFieldJavaType().get(autoIncrColum);
        if (Long.class.equals(autoIncrType)) {
            PojoOperatorFactory.getPojoOperator().doSetter(t, autoIncrAttri, (long)autoIncrValue);
        } else if (Integer.class.equals(autoIncrType)) {
            PojoOperatorFactory.getPojoOperator().doSetter(t, autoIncrAttri, autoIncrValue.intValue());
        } else if (Short.class.equals(autoIncrType)) {
            PojoOperatorFactory.getPojoOperator().doSetter(t, autoIncrAttri, autoIncrValue.shortValue());
        } else {
            throw new IllegalArgumentException(String.format("AUTO_INCREMENT type %s not supported in Table %s", autoIncrType.getSimpleName(), t.getClass().getSimpleName()));
        }
        return rowsAffect.get();
    }

    @Override
    public int updateObject(T t) {
        return this.updateObject(t, true);
    }

    @Override
    public int updateObject(T t, String ... whereCondiFields) {
        return this.updateObject(t, true, whereCondiFields);
    }

    @Override
    public int updateObject(T t, boolean affectExpected) {
        String sqlUpdate = this.sqlGenerator.genSQLUpdate(t);
        return this.doUpdateSql(sqlUpdate, affectExpected);
    }

    @Override
    public int updateObject(T t, boolean affectExpected, String ... whereCondiFields) {
        String sqlUpdate = this.sqlGenerator.genSQLUpdate(t, whereCondiFields);
        return this.doUpdateSql(sqlUpdate, affectExpected);
    }

    private int doUpdateSql(String sqlUpdate, boolean affectExpected) {
        return this.doUpdateSql(sqlUpdate, affectExpected, false);
    }

    private int doUpdateSql(String sqlUpdate, boolean affectExpected, boolean isDelete) {
        LOGGER.debug("SQL: {}", (Object)sqlUpdate);
        int rows = this.getJdbcTemplate().update(sqlUpdate);
        if (affectExpected && rows <= 0) {
            throw new IllegalStateException("no rows affected for " + (isDelete ? "delete" : "update") + ": " + sqlUpdate);
        }
        return rows;
    }

    @Override
    public T findObject(T t) {
        String sqlSelect = this.sqlGenerator.genSQLSelect(t);
        LOGGER.debug("SQL: {}", (Object)sqlSelect);
        List list = this.getJdbcTemplate().query(sqlSelect, new ORMRowMapper(t.getClass()));
        if (list == null || list.size() == 0) {
            return null;
        }
        return (T)list.get(0);
    }

    @Override
    public List<T> findObjectsLimit(T t, int offset, int length) {
        return this.findObjects(t, HQL.limit(offset, length));
    }

    @Override
    public List<T> findObjectsOrderByLimit(T t, int offset, int length, String ... orderByFields) {
        return this.findObjects(t, HQL.orderBy(orderByFields), HQL.limit(offset, length));
    }

    @Override
    public List<T> findObjectsOrderBy(T t, String ... orderByFields) {
        return this.findObjects(t, HQL.orderBy(orderByFields));
    }

    @Override
    public List<T> findObjects(T t) {
        String sqlSelect = this.sqlGenerator.genSQLSelect(t);
        LOGGER.debug("SQL: {}", (Object)sqlSelect);
        return this.getJdbcTemplate().query(sqlSelect, new ORMRowMapper(t.getClass()));
    }

    @Override
    public List<T> findObjects(T t, HQL ... hqls) {
        String sqlSelect = this.sqlGenerator.genSQLSelect(t, hqls);
        LOGGER.debug("SQL: {}", (Object)sqlSelect);
        return this.getJdbcTemplate().query(sqlSelect, new ORMRowMapper(t.getClass()));
    }

    @Override
    public List<T> findObjects(String rawSQL, Class<T> mapClass) {
        LOGGER.debug("rawSQL: {}", (Object)rawSQL);
        return this.getJdbcTemplate().query(rawSQL, new ORMRowMapper(mapClass));
    }

    @Override
    public <K> List<K> findObjectsAny(String rawSQL, Class<K> mapClass) {
        LOGGER.debug("rawSQL: {}", (Object)rawSQL);
        return this.getJdbcTemplate().query(rawSQL, new ORMRowMapper(mapClass, false, true));
    }

    @Override
    public int removeObjects(T t) {
        return this.removeObjects(t, false);
    }

    @Override
    public int removeObjects(T t, boolean affectExpected) {
        String sqlDelete = this.sqlGenerator.genSQLDelete(t);
        LOGGER.debug("SQL: {}", (Object)sqlDelete);
        return this.doUpdateSql(sqlDelete, affectExpected, true);
    }

    @Override
    public Long queryForLong(String rawSQL) {
        LOGGER.debug("SQL: {}", (Object)rawSQL);
        return this.getJdbcTemplate().queryForLong(rawSQL);
    }

    @Override
    public Integer queryForInt(String rawSQL) {
        LOGGER.debug("SQL: {}", (Object)rawSQL);
        return this.getJdbcTemplate().queryForInt(rawSQL);
    }
}

